/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrixUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LILSparseMatrix
implements SparseMatrix {
    private final SparseVector[] void;
    private final int class;
    private static final MatrixMathOperation goto = new AutoParallelMatrixMathOperation();
    private final int enum;

    public String toString() {
        return SparseMatrixUtils.toString(this);
    }

    @Override
    public LILSparseMatrix scaled(double c2) {
        if (c2 == 0.0) {
            return new LILSparseMatrix(this.enum, this.class);
        }
        SparseVector[] a2 = new SparseVector[this.enum];
        for (int a3 = 0; a3 < this.enum; ++a3) {
            a2[a3] = this.void[a3].scaled(c2);
        }
        return new LILSparseMatrix(a2);
    }

    @Override
    public LILSparseMatrix subMatrix(int rowFrom, int rowTo, int colFrom, int colTo) {
        ArgumentAssertion.assertGreaterThan(rowFrom, 0, "rowFrom");
        ArgumentAssertion.assertGreaterThan(colFrom, 0, "colFrom");
        ArgumentAssertion.assertNotGreaterThan(rowTo, this.enum, "rowTo");
        ArgumentAssertion.assertNotGreaterThan(colTo, this.class, "colTo");
        ArgumentAssertion.assertTrue(rowFrom <= rowTo, "rowFrom <= rowTo", new Object[0]);
        ArgumentAssertion.assertTrue(colFrom <= colTo, "colfrom <= colTo", new Object[0]);
        LILSparseMatrix a2 = new LILSparseMatrix(rowTo - rowFrom + 1, colTo - colFrom + 1);
        for (int a3 = rowFrom; a3 <= rowTo; ++a3) {
            for (SparseVector.Entry a4 : this.void[a3 - 1]) {
                if (a4.index() < colFrom || a4.index() > colTo) continue;
                a2.set(a3 - rowFrom + 1, a4.index() - colFrom + 1, a4.value());
            }
        }
        return a2;
    }

    @Override
    public int nCols() {
        return this.class;
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.short((LILSparseMatrix)that);
        }
        return goto.minus(this, that);
    }

    private LILSparseMatrix case(LILSparseMatrix a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a3, a2);
        LILSparseMatrix a4 = a2.t();
        SparseVector[] a5 = new SparseVector[a2.class];
        for (int a6 = 0; a6 < a2.class; ++a6) {
            a5[a6] = a3.do(a4.void[a6]);
        }
        return new LILSparseMatrix(a5).t();
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 59 * a2 + Arrays.deepHashCode(this.void);
        a2 = 59 * a2 + this.enum;
        a2 = 59 * a2 + this.class;
        return a2;
    }

    @Override
    public LILSparseMatrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public LILSparseMatrix ONE() {
        int a2 = Math.min(this.enum, this.class);
        double[] a3 = DoubleUtils.rep(1.0, a2);
        int[] a4 = DoubleUtils.seq(1, a2);
        int[] a5 = DoubleUtils.seq(1, a2);
        return new LILSparseMatrix(this.enum, this.class, a4, a5, a3);
    }

    private SparseVector do(SparseVector a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a3, a2);
        SparseVector a4 = new SparseVector(a3.enum);
        double a5 = 0.0;
        for (int a6 = 0; a6 < a3.enum; ++a6) {
            a5 = a3.void[a6].innerProduct(a2);
            if (Double.compare(0.0, a5) == 0) continue;
            a4.set(a6 + 1, a5);
        }
        return a4;
    }

    @Override
    public int nNonZeros() {
        int a2 = 0;
        for (SparseVector a3 : this.void) {
            a2 += a3.nNonZeros();
        }
        return a2;
    }

    private LILSparseMatrix(SparseVector[] a2) {
        LILSparseMatrix a3;
        a3.enum = a2.length;
        a3.class = a2[0].size();
        a3.void = a2;
    }

    private LILSparseMatrix short(LILSparseMatrix a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfDifferentDimension(a3, a2);
        SparseVector[] a4 = new SparseVector[a3.enum];
        for (int a5 = 0; a5 < a3.enum; ++a5) {
            a4[a5] = a3.void[a5].minus(a2.void[a5]);
        }
        return new LILSparseMatrix(a4);
    }

    public LILSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] value) {
        this(nRows, nCols);
        ArgumentAssertion.assertTrue(rowIndices.length == columnIndices.length && rowIndices.length == value.length, "input arrays size mismatch", new Object[0]);
        for (int a2 = 0; a2 < value.length; ++a2) {
            this.void[rowIndices[a2] - 1].set(columnIndices[a2], value[a2]);
        }
    }

    @Override
    public LILSparseMatrix t() {
        LILSparseMatrix a2 = new LILSparseMatrix(this.class, this.enum);
        for (int a3 = 0; a3 < this.enum; ++a3) {
            for (SparseVector.Entry a4 : this.void[a3]) {
                a2.set(a4.index(), a3 + 1, a4.value());
            }
        }
        return a2;
    }

    public LILSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries) {
        this(nRows, nCols);
        SparseMatrixUtils.sortInRowColumnOrder(entries, nRows, nCols, true, true);
        MatrixCoordinate a2 = null;
        for (SparseMatrix.Entry a3 : entries) {
            MatrixCoordinate a4 = a3.coordinates;
            ArgumentAssertion.assertTrue(a2 == null || !a2.equals(a4), "repeated entry at coordinates %s", a4);
            a2 = a4;
            this.void[a3.coordinates.i - 1].set(a3.coordinates.j, a3.value);
        }
    }

    @Override
    public SparseMatrix.ValueArray getValueArray() {
        int a2 = this.nNonZeros();
        int[] a3 = new int[a2];
        int[] a4 = new int[a2];
        double[] a5 = new double[a2];
        int a6 = 0;
        for (int a7 = 1; a7 <= this.enum; ++a7) {
            for (SparseVector.Entry a8 : this.void[a7 - 1]) {
                a3[a6] = a7;
                a4[a6] = a8.index();
                a5[a6] = a8.value();
                ++a6;
            }
        }
        return new SparseMatrix.ValueArray(a3, a4, a5);
    }

    @Override
    public void set(int row, int col, double value) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        this.void[row - 1].set(col, value);
    }

    @Override
    public SparseVector getColumn(int j2) {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        SparseVector a2 = new SparseVector(this.enum);
        for (int a3 = 1; a3 <= this.enum; ++a3) {
            double a4 = this.get(a3, j2);
            if (Double.compare(0.0, a4) == 0) continue;
            a2.set(a3, a4);
        }
        return a2;
    }

    @Override
    public double get(int row, int col) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.void[row - 1].get(col);
    }

    @Override
    public LILSparseMatrix ZERO() {
        return new LILSparseMatrix(this.enum, this.class);
    }

    public LILSparseMatrix(int nRows, int nCols) {
        this.enum = nRows;
        this.class = nCols;
        this.void = new SparseVector[nRows];
        for (int a2 = 0; a2 < nRows; ++a2) {
            this.void[a2] = new SparseVector(nCols);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SparseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        LILSparseMatrix a2 = (LILSparseMatrix)obj;
        if (this.enum != a2.enum) {
            return false;
        }
        if (this.class != a2.class) {
            return false;
        }
        return SparseMatrixUtils.equals(this, a2);
    }

    @Override
    public DenseMatrix toDense() {
        Object a2 = new DenseMatrix(this.enum, this.class).ZERO();
        int a3 = 1;
        for (SparseVector a4 : this.void) {
            for (SparseVector.Entry a5 : a4) {
                ((DenseMatrix)a2).set(a3, a5.index(), a5.value());
            }
            ++a3;
        }
        return a2;
    }

    @Override
    public List<SparseMatrix.Entry> getEntryList() {
        ArrayList<SparseMatrix.Entry> a2 = new ArrayList<SparseMatrix.Entry>(this.nNonZeros());
        int a3 = 0;
        for (int a4 = 1; a4 <= this.enum; ++a4) {
            for (SparseVector.Entry a5 : this.void[a4 - 1]) {
                a2.add(a3++, new SparseMatrix.Entry(new MatrixCoordinate(a4, a5.index()), a5.value()));
            }
        }
        return a2;
    }

    @Override
    public int nRows() {
        return this.enum;
    }

    @Override
    public SparseVector getRow(int i2) {
        DimensionCheck.throwIfInvalidRow(this, i2);
        return new SparseVector(this.void[i2 - 1]);
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.case((LILSparseMatrix)that);
        }
        return goto.multiply((MatrixAccess)this, that);
    }

    @Override
    public Vector multiply(Vector v) {
        if (v instanceof SparseVector) {
            return this.do((SparseVector)v);
        }
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        double[] a2 = new double[this.enum];
        for (int a3 = 0; a3 < this.enum; ++a3) {
            a2[a3] = this.void[a3].innerProduct(v);
        }
        return new DenseVector(a2);
    }

    public LILSparseMatrix(LILSparseMatrix that) {
        this(that.enum, that.class);
        for (int a2 = 0; a2 < this.enum; ++a2) {
            this.void[a2] = new SparseVector(that.void[a2]);
        }
    }

    @Override
    public LILSparseMatrix deepCopy() {
        return new LILSparseMatrix(this);
    }

    private LILSparseMatrix do(LILSparseMatrix a2) {
        LILSparseMatrix a3;
        DimensionCheck.throwIfDifferentDimension(a3, a2);
        SparseVector[] a4 = new SparseVector[a3.enum];
        for (int a5 = 0; a5 < a3.enum; ++a5) {
            a4[a5] = a3.void[a5].add(a2.void[a5]);
        }
        return new LILSparseMatrix(a4);
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof LILSparseMatrix) {
            return this.do((LILSparseMatrix)that);
        }
        return goto.add(this, that);
    }
}

