/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrixUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DOKSparseMatrix
implements SparseMatrix {
    private final int void;
    private static final MatrixMathOperation class = new AutoParallelMatrixMathOperation();
    private final int goto;
    private Map<MatrixCoordinate, Double> enum;

    public String toString() {
        return SparseMatrixUtils.toString(this);
    }

    public DOKSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] value) {
        this(nRows, nCols);
        this.enum = new HashMap<MatrixCoordinate, Double>(value.length);
        ArgumentAssertion.assertTrue(rowIndices.length == columnIndices.length && rowIndices.length == value.length, "input arrays size mismatch", new Object[0]);
        for (int a2 = 0; a2 < rowIndices.length; ++a2) {
            this.do(rowIndices[a2], columnIndices[a2], value[a2]);
        }
    }

    public DOKSparseMatrix(DOKSparseMatrix that) {
        this(that.void, that.goto);
        this.enum = new HashMap<MatrixCoordinate, Double>(that.enum);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 71 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
        a2 = 71 * a2 + this.void;
        a2 = 71 * a2 + this.goto;
        return a2;
    }

    @Override
    public int nCols() {
        return this.goto;
    }

    @Override
    public Matrix multiply(Matrix that) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, that);
        int a2 = that.nCols();
        Densifiable a3 = that instanceof SparseMatrix ? new DOKSparseMatrix(this.void, a2) : new DenseMatrix(this.void, a2);
        for (Map.Entry<MatrixCoordinate, Double> a4 : this.enum.entrySet()) {
            int a5 = a4.getKey().i;
            int a6 = a4.getKey().j;
            double a7 = a4.getValue();
            for (int a8 = 1; a8 <= a2; ++a8) {
                a3.set(a5, a8, a3.get(a5, a8) + a7 * that.get(a6, a8));
            }
        }
        return a3;
    }

    @Override
    public SparseMatrix.ValueArray getValueArray() {
        int a2 = this.nNonZeros();
        int[] a3 = new int[a2];
        int[] a4 = new int[a2];
        double[] a5 = new double[a2];
        int a6 = 0;
        for (Map.Entry<MatrixCoordinate, Double> a7 : this.enum.entrySet()) {
            MatrixCoordinate a8 = a7.getKey();
            a3[a6] = a8.i;
            a4[a6] = a8.j;
            a5[a6] = a7.getValue();
            ++a6;
        }
        return new SparseMatrix.ValueArray(a3, a4, a5);
    }

    public DOKSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries) {
        this(nRows, nCols);
        this.enum = new HashMap<MatrixCoordinate, Double>(entries.size());
        for (SparseMatrix.Entry a2 : entries) {
            Double a3 = this.do(a2.coordinates.i, a2.coordinates.j, a2.value);
            ArgumentAssertion.assertTrue(a3 == null, "repeated entry at coordinates %s", a2.coordinates);
        }
    }

    @Override
    public List<SparseMatrix.Entry> getEntryList() {
        ArrayList<SparseMatrix.Entry> a2 = new ArrayList<SparseMatrix.Entry>(this.nNonZeros());
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            a2.add(new SparseMatrix.Entry(a3.getKey(), a3.getValue()));
        }
        SparseMatrixUtils.sortInRowColumnOrder(a2, this.void, this.goto, false, false);
        return a2;
    }

    @Override
    public DOKSparseMatrix scaled(double c2) {
        if (Double.compare(0.0, c2) == 0) {
            return new DOKSparseMatrix(this.void, this.goto);
        }
        DOKSparseMatrix a2 = new DOKSparseMatrix(this.void, this.goto);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            a2.enum.put(a3.getKey(), c2 * a3.getValue());
        }
        return a2;
    }

    @Override
    public int nRows() {
        return this.void;
    }

    @Override
    public DOKSparseMatrix ZERO() {
        return new DOKSparseMatrix(this.void, this.goto);
    }

    @Override
    public void set(int row, int col, double value) {
        this.do(row, col, value);
    }

    @Override
    public DOKSparseMatrix ONE() {
        int a2 = Math.min(this.void, this.goto);
        double[] a3 = DoubleUtils.rep(1.0, a2);
        int[] a4 = DoubleUtils.seq(1, a2);
        int[] a5 = DoubleUtils.seq(1, a2);
        return new DOKSparseMatrix(this.void, this.goto, a4, a5, a3);
    }

    @Override
    public int nNonZeros() {
        return this.enum.size();
    }

    public DOKSparseMatrix(int nRows, int nCols) {
        this.void = nRows;
        this.goto = nCols;
        this.enum = new HashMap<MatrixCoordinate, Double>();
    }

    @Override
    public SparseMatrix subMatrix(int rowFrom, int rowTo, int colFrom, int colTo) {
        ArgumentAssertion.assertGreaterThan(rowFrom, 0, "rowFrom");
        ArgumentAssertion.assertGreaterThan(colFrom, 0, "colFrom");
        ArgumentAssertion.assertNotGreaterThan(rowTo, this.void, "rowTo");
        ArgumentAssertion.assertNotGreaterThan(colTo, this.goto, "colTo");
        ArgumentAssertion.assertTrue(rowFrom <= rowTo, "rowFrom <= rowTo", new Object[0]);
        ArgumentAssertion.assertTrue(colFrom <= colTo, "colfrom <= colTo", new Object[0]);
        int a2 = rowTo - rowFrom + 1;
        int a3 = colTo - colFrom + 1;
        DOKSparseMatrix a4 = new DOKSparseMatrix(a2, a3);
        if (this.nNonZeros() < a2 * a3) {
            this.enum.entrySet().forEach(a7 -> {
                int a8 = ((MatrixCoordinate)a7.getKey()).i;
                int a9 = ((MatrixCoordinate)a7.getKey()).j;
                if (a8 >= rowFrom && a8 <= rowTo && a9 >= colFrom && a9 <= colTo) {
                    a4.set(a8 - rowFrom + 1, a9 - colTo + 1, (Double)a7.getValue());
                }
            });
        } else {
            for (int a5 = rowFrom; a5 <= rowTo; ++a5) {
                for (int a6 = colFrom; a6 <= colTo; ++a6) {
                    Double a8 = this.enum.get(new MatrixCoordinate(a5, a6));
                    if (a8 == null) continue;
                    a4.set(a5 - rowFrom + 1, a6 - colFrom + 1, a8);
                }
            }
        }
        return a4;
    }

    @Override
    public Vector multiply(Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        Vector a2 = v instanceof SparseVector ? new SparseVector(this.void) : new DenseVector(this.void);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            double a4 = a3.getValue() * v.get(a3.getKey().j);
            int a5 = a3.getKey().i;
            a2.set(a5, a2.get(a5) + a4);
        }
        return a2;
    }

    private Double do(int a2, int a3, double a4) {
        DOKSparseMatrix a5;
        DimensionCheck.throwIfInvalidRow(a5, a2);
        DimensionCheck.throwIfInvalidColumn(a5, a3);
        if (Double.compare(0.0, a4) != 0) {
            return a5.enum.put(new MatrixCoordinate(a2, a3), a4);
        }
        return a5.enum.remove(new MatrixCoordinate(a2, a3));
    }

    private DOKSparseMatrix do(DOKSparseMatrix a2, int a3) {
        DOKSparseMatrix a4;
        DimensionCheck.throwIfDifferentDimension(a4, a2);
        DOKSparseMatrix a5 = new DOKSparseMatrix(a4);
        for (Map.Entry<MatrixCoordinate, Double> a6 : a2.enum.entrySet()) {
            MatrixCoordinate a7 = a6.getKey();
            Double a8 = a5.enum.get(a7);
            a8 = a8 == null ? (double)a3 * a6.getValue() : a8 + (double)a3 * a6.getValue();
            if (Double.compare(0.0, a8) != 0) {
                a5.enum.put(a7, a8);
                continue;
            }
            a5.enum.remove(a7);
        }
        return a5;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SparseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        DOKSparseMatrix a2 = (DOKSparseMatrix)obj;
        if (this.void != a2.void) {
            return false;
        }
        if (this.goto != a2.goto) {
            return false;
        }
        return SparseMatrixUtils.equals(this, a2);
    }

    @Override
    public DOKSparseMatrix deepCopy() {
        return new DOKSparseMatrix(this);
    }

    @Override
    public DOKSparseMatrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public double get(int i2, int j2) {
        DimensionCheck.throwIfInvalidRow(this, i2);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        Double a2 = this.enum.get(new MatrixCoordinate(i2, j2));
        return a2 == null ? 0.0 : a2;
    }

    @Override
    public DOKSparseMatrix t() {
        DOKSparseMatrix a2 = new DOKSparseMatrix(this.goto, this.void);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            MatrixCoordinate a4 = a3.getKey();
            a2.set(a4.j, a4.i, a3.getValue());
        }
        return a2;
    }

    @Override
    public SparseVector getRow(int i2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        SparseVector a2 = new SparseVector(this.goto);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            if (a3.getKey().i != i2) continue;
            a2.set(a3.getKey().j, a3.getValue());
        }
        return a2;
    }

    @Override
    public SparseVector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        SparseVector a2 = new SparseVector(this.void);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            if (a3.getKey().j != j2) continue;
            a2.set(a3.getKey().i, a3.getValue());
        }
        return a2;
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof DOKSparseMatrix) {
            return this.do((DOKSparseMatrix)that, 1);
        }
        return DOKSparseMatrix.class.add(this, that);
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = new DenseMatrix(this.void, this.goto);
        for (Map.Entry<MatrixCoordinate, Double> a3 : this.enum.entrySet()) {
            MatrixCoordinate a4 = a3.getKey();
            a2.set(a4.i, a4.j, a3.getValue());
        }
        return a2;
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof DOKSparseMatrix) {
            return this.do((DOKSparseMatrix)that, -1);
        }
        return DOKSparseMatrix.class.minus(this, that);
    }
}

