/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.linearsystem;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.number.DoubleUtils;
import java.util.concurrent.ExecutionException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BackwardSubstitution {
    public Matrix solve(UpperTriangularMatrix U, Matrix B2) {
        return this.solve(U, B2, 0.0);
    }

    private Vector do(UpperTriangularMatrix a2, Vector a3, double a4) {
        int a5 = a3.size();
        DenseVector a6 = new DenseVector(a5);
        for (int a7 = a5; a7 >= 1; --a7) {
            double a8 = 0.0;
            for (int a9 = a7 + 1; a9 <= a5; ++a9) {
                a8 += a2.get(a7, a9) * a6.get(a9);
            }
            double a10 = a3.get(a7) - a8;
            if (!DoubleUtils.isZero(a2.get(a7, a7), a4)) {
                a6.set(a7, a10 / a2.get(a7, a7));
                continue;
            }
            if (DoubleUtils.isZero(a10, a4)) continue;
            throw new LinearSystemSolver.NoSolution("no solution to this system of linear equations");
        }
        return a6;
    }

    public Matrix solve(final UpperTriangularMatrix U, final Matrix B2, final double epsilon) {
        ArgumentAssertion.assertEqual(U.nRows(), B2.nRows(), "#rows in U", "#rows in B");
        int a2 = U.nCols();
        int a3 = B2.nCols();
        final DenseMatrix a4 = new DenseMatrix(a2, a3);
        try {
            ParallelExecutor.getSharedInstance().forLoop(1, a3 + 1, new LoopBody(){
                {
                    1 a3;
                }

                @Override
                public void run(int j2) throws Exception {
                    Vector a2 = B2.getColumn(j2);
                    Vector a3 = BackwardSubstitution.this.do(U, a2, epsilon);
                    a4.setColumn(j2, a3);
                }
            });
        }
        catch (MultipleExecutionException a5) {
            for (ExecutionException a6 : a5.getExceptions()) {
                if (a6 == null) continue;
                throw new LinearSystemSolver.NoSolution(a6.getCause().getMessage());
            }
        }
        return a4;
    }

    public Vector solve(UpperTriangularMatrix U, Vector b2) {
        ArgumentAssertion.assertEqual(U.nRows(), b2.size(), "U's dimension", "b's size");
        return this.solve(U, b2, 0.0);
    }

    public Vector solve(UpperTriangularMatrix U, Vector b2, double epsilon) {
        ArgumentAssertion.assertEqual(U.nRows(), b2.size(), "#rows in U", "#rows in B");
        return this.do(U, b2, epsilon);
    }
}

