/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.socp.constraints.ybar;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.VectorMathOperation;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPLinearInequalities;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPLinearInequality;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;
import java.util.ArrayList;
import java.util.stream.IntStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOCPLinearSectorExposure
extends SOCPPortfolioConstraint {
    private final int const;
    private final int void;
    private final Vector class;
    private final Vector[] goto;
    private final double enum;
    public static final double DEFAULT_EPSILON = 1.0E-6;

    @Override
    public int dimensionOfRange() {
        return 1;
    }

    public SOCPLinearSectorExposure(Vector[] S, Vector u, double epsilon) {
        ArgumentAssertion.assertPositive(S.length, "#sectors");
        ArgumentAssertion.assertTrue(S.length == u.size(), "#sectors (%d) and u's size (%d) must match", S.length, u.size());
        this.goto = S;
        this.const = S[0].size();
        this.void = S.length;
        this.class = u;
        IntStream.range(0, this.void).forEach(a3 -> {
            SOCPLinearSectorExposure a4;
            ArgumentAssertion.assertTrue(S[a3].size() == a4.const, "S[%d] is not of the same size (%d)", a3, a4.const);
        });
        this.enum = epsilon;
        SOCPLinearInequalities a2 = this.newSOCPLinearInequalities(new SOCPPortfolioConstraint.Variable("y", this.const), new SOCPPortfolioConstraint.Variable("ybar", this.const));
        for (int a4 = 0; a4 < this.void; ++a4) {
            ArrayList<SparseMatrix.Entry> a5 = new ArrayList<SparseMatrix.Entry>();
            Vector a6 = S[a4];
            int a7 = (int)IntStream.rangeClosed(1, this.const).filter(a3 -> {
                SOCPLinearSectorExposure a4;
                return DoubleUtils.equal(a6.get(a3), 1.0, a4.enum);
            }).count();
            if (a7 == 0) continue;
            int a8 = 0;
            for (int a9 = 1; a9 <= this.const; ++a9) {
                if (!DoubleUtils.equal(a6.get(a9), 1.0, epsilon)) continue;
                a5.add(new SparseMatrix.Entry(new MatrixCoordinate(a9 + this.const, 1), 1.0));
                a5.add(new SparseMatrix.Entry(new MatrixCoordinate(a9, ++a8 + 1), 1.0));
                a5.add(new SparseMatrix.Entry(new MatrixCoordinate(a9 + this.const, a8 + 1), -1.0));
                a5.add(new SparseMatrix.Entry(new MatrixCoordinate(a9, a8 + 1 + a7), -1.0));
                a5.add(new SparseMatrix.Entry(new MatrixCoordinate(a9 + this.const, a8 + 1 + a7), -1.0));
            }
            CSRSparseMatrix a10 = new CSRSparseMatrix(this.const * 2, 1 + a7 * 2, a5);
            SparseVector a22 = new SparseVector(1 + a7 * 2);
            a22.set(1, u.get(a4 + 1));
            a2.add(new SOCPLinearInequality(a10, a22));
        }
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) throws SOCPPortfolioConstraint.ConstraintViolationException {
        Vector a2 = VectorMathOperation.abs(y);
        for (int a3 = 0; a3 < this.void; ++a3) {
            double a4 = a2.innerProduct(this.goto[a3]) - this.class.get(a3 + 1);
            if (DoubleUtils.compare(a4, 0.0, this.enum) <= 0) continue;
            throw new SOCPPortfolioConstraint.ConstraintViolationException(String.format("exceeding %d-th sector exposure (limit=%f) by %f: %s", a3, this.class.get(a3 + 1), a4, y));
        }
        return true;
    }

    @Override
    public int dimensionOfDomain() {
        return this.const;
    }

    @Override
    public Double evaluate(Vector y) {
        Vector a2 = VectorMathOperation.abs(y);
        double a3 = 0.0;
        for (int a4 = 0; a4 < this.void; ++a4) {
            double a5 = a2.innerProduct(this.goto[a4]) - this.class.get(a4 + 1);
            a3 += a5;
        }
        return a3;
    }

    static {
        Package.validate("ALGOQUANT_SOCP_CONSTRAINTS");
    }

    public SOCPLinearSectorExposure(Vector[] S, Vector u) {
        this(S, u, 1.0E-6);
    }
}

