/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.socp.constraints;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraint;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOCPZeroValue
extends SOCPPortfolioConstraint {
    private final int class;
    private final Vector goto;
    private final double enum;

    public SOCPZeroValue(Vector w_0) {
        this(w_0, 0.01);
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) throws SOCPPortfolioConstraint.ConstraintViolationException {
        double a2 = this.evaluate(y);
        if (DoubleUtils.compare(a2, 0.0, this.enum) != 0) {
            throw new SOCPPortfolioConstraint.ConstraintViolationException(String.format("portfolio not zero value: %f, %s", a2, y.toString()));
        }
        return true;
    }

    public SOCPZeroValue(Vector w_0, double epsilon) {
        this.goto = w_0;
        this.class = w_0.size();
        this.enum = epsilon;
        SOCPGeneralConstraints a2 = this.newSOCPGeneralConstraints(new SOCPPortfolioConstraint.Variable("y", this.class));
        ArrayList<SparseMatrix.Entry> a3 = new ArrayList<SparseMatrix.Entry>();
        for (int a4 = 0; a4 < this.class; ++a4) {
            a3.add(new SparseMatrix.Entry(new MatrixCoordinate(1, a4 + 1), 1.0));
        }
        CSRSparseMatrix a5 = new CSRSparseMatrix(1, this.class, a3);
        SparseVector a6 = new SparseVector(1);
        SparseVector a7 = new SparseVector(this.class);
        double a8 = 0.0;
        a2.add(new SOCPGeneralConstraint(a5.t(), a6, a7, a8));
    }

    @Override
    public int dimensionOfDomain() {
        return this.goto.size();
    }

    static {
        Package.validate("ALGOQUANT_SOCP_CONSTRAINTS");
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }

    @Override
    public Double evaluate(Vector y) {
        double a2 = this.bias(y);
        return a2;
    }

    public double bias(Vector y) {
        double a2 = 0.0;
        for (int a3 = 1; a3 <= this.class; ++a3) {
            a2 += y.get(a3);
        }
        return a2;
    }
}

