/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.socp.constraints;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPLinearEqualities;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPLinearEquality;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOCPLinearBlackList
extends SOCPPortfolioConstraint {
    private final int class;
    public static final double DEFAULT_EPSILON = 1.0E-6;
    private final List<Integer> goto;
    private final double enum;

    static {
        Package.validate("ALGOQUANT_SOCP_CONSTRAINTS");
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) throws SOCPPortfolioConstraint.ConstraintViolationException {
        for (int a2 : this.goto) {
            if (DoubleUtils.isZero(y.get(a2), this.enum)) continue;
            throw new SOCPPortfolioConstraint.ConstraintViolationException(String.format("non-zero position for a blacklisted asset [%d]: %f", a2, y.get(a2)));
        }
        return true;
    }

    public SOCPLinearBlackList(int nAssets, Collection<Integer> blacklist, double epsilon) {
        this.class = nAssets;
        this.goto = new ArrayList<Integer>(new TreeSet<Integer>(blacklist));
        this.goto.forEach(a2 -> {
            SOCPLinearBlackList a3;
            ArgumentAssertion.assertRange(a2, 1, a3.class, "blacklist index");
        });
        this.enum = epsilon;
        SOCPLinearEqualities a3 = this.newSOCPLinearEqualities(new SOCPPortfolioConstraint.Variable("y", this.class));
        int a4 = this.goto.size();
        List<SparseMatrix.Entry> a5 = IntStream.rangeClosed(1, a4).boxed().map(a2 -> {
            SOCPLinearBlackList a3;
            return new SparseMatrix.Entry(new MatrixCoordinate(a3.goto.get(a2 - 1), (int)a2), 1.0);
        }).collect(Collectors.toList());
        CSRSparseMatrix a6 = new CSRSparseMatrix(this.class, a4, a5);
        SparseVector a7 = new SparseVector(a4);
        a3.add(new SOCPLinearEquality(a6, a7));
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }

    @Override
    public Double evaluate(Vector x) {
        if (this.goto.isEmpty()) {
            return 0.0;
        }
        double a2 = 0.0;
        for (int a3 : this.goto) {
            a2 += Math.abs(x.get(a3));
        }
        double a4 = a2 / (double)this.goto.size();
        return a4;
    }

    @Override
    public int dimensionOfDomain() {
        return this.class;
    }

    public SOCPLinearBlackList(int nAssets, Collection<Integer> blacklist) {
        this(nAssets, blacklist, 1.0E-6);
    }
}

