/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.univariate.arima;

import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.timeseries.linear.univariate.stationaryprocess.arma.ARMAXModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ARIMAXModel {
    private final double catch;
    private final double[] const;
    private final int void;
    private final double[] class;
    private final double goto;
    private final double[] enum;

    public ARIMAXModel(double mu, double[] AR, int d2, double[] MA, double[] psi) {
        this(mu, AR, d2, MA, psi, 1.0);
    }

    public int d() {
        return this.void;
    }

    public double AR(int i2) {
        return i2 <= this.p() ? this.const[i2] : 0.0;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append("x_t = ");
        a3.append(this.catch);
        a3.append(" + (");
        if (this.const != null) {
            for (a2 = 1; a2 < this.const.length; ++a2) {
                a3.append(this.const[a2]);
                a3.append(String.format("*x_{t-%d}", a2));
                if (a2 == this.const.length - 1) continue;
                a3.append("+");
            }
        }
        a3.append(")");
        a3.append(" + (");
        if (this.class != null) {
            for (a2 = 1; a2 < this.class.length; ++a2) {
                a3.append(this.class[a2]);
                a3.append(String.format("*e_{t-%d}", a2));
                if (a2 == this.class.length - 1) continue;
                a3.append("+");
            }
        }
        a3.append(")");
        if (this.enum != null) {
            a3.append(" + (");
            for (a2 = 0; a2 < this.enum.length; ++a2) {
                a3.append(this.enum[a2]);
                a3.append(String.format("*D_{t-%d}", a2));
                if (a2 == this.enum.length - 1) continue;
                a3.append("+");
            }
            a3.append(")");
        }
        a3.append(" + e_t");
        a3.append(String.format("; var(e_t) = %f, d = %d", this.goto, this.void));
        return a3.toString();
    }

    public double sigma() {
        return this.goto;
    }

    public ARIMAXModel(double mu, double[] AR, int d2, double[] MA, double[] psi, double sigma) {
        int a2;
        ArgumentAssertion.assertTrue(AR != null || MA != null, "at least one of AR and MA terms cannot be null", new Object[0]);
        ArgumentAssertion.assertNonNegative(d2, "d");
        ArgumentAssertion.assertNonNegative(sigma, "sigma");
        this.catch = mu;
        this.const = new double[AR != null ? AR.length + 1 : 1];
        this.const[0] = 1.0;
        for (a2 = 1; a2 < this.const.length; ++a2) {
            this.const[a2] = AR[a2 - 1];
        }
        this.class = new double[MA != null ? MA.length + 1 : 1];
        this.class[0] = 1.0;
        for (a2 = 1; a2 < this.class.length; ++a2) {
            this.class[a2] = MA[a2 - 1];
        }
        this.enum = psi != null ? Arrays.copyOf(psi, psi.length) : null;
        this.void = d2;
        this.goto = sigma;
    }

    public double[] theta() {
        return Arrays.copyOf(this.class, this.class.length);
    }

    public ARMAXModel getARMAX() {
        return new ARMAXModel(this.catch, Arrays.copyOfRange(this.const, 1, this.const.length), Arrays.copyOfRange(this.class, 1, this.class.length), this.enum, this.goto);
    }

    public double[] phi() {
        return Arrays.copyOf(this.const, this.const.length);
    }

    public Polynomial phiPolynomial() {
        double[] a2 = new double[this.p() + 1];
        a2[0] = 1.0;
        for (int a3 = 1; a3 < a2.length; ++a3) {
            a2[a3] = -this.AR(a3);
        }
        DoubleUtils.reverse(a2);
        return new Polynomial(a2);
    }

    public ARIMAXModel(ARIMAXModel that) {
        this.catch = that.catch;
        this.const = Arrays.copyOf(that.const, that.const.length);
        this.class = Arrays.copyOf(that.class, that.class.length);
        this.enum = that.enum != null ? Arrays.copyOf(that.enum, that.enum.length) : null;
        this.void = that.void;
        this.goto = that.goto;
    }

    public ARIMAXModel(double[] AR, int d2, double[] MA, double[] psi) {
        this(0.0, AR, d2, MA, psi, 1.0);
    }

    public double MA(int i2) {
        return i2 <= this.q() ? this.class[i2] : 0.0;
    }

    public ARIMAXModel(double[] AR, int d2, double[] MA, double[] psi, double sigma) {
        this(0.0, AR, d2, MA, psi, sigma);
    }

    public Polynomial thetaPolynomial() {
        double[] a2 = new double[this.q() + 1];
        a2[0] = 1.0;
        for (int a3 = 1; a3 < a2.length; ++a3) {
            a2[a3] = this.MA(a3);
        }
        DoubleUtils.reverse(a2);
        return new Polynomial(a2);
    }

    public int q() {
        return this.class.length - 1;
    }

    public int p() {
        return this.const.length - 1;
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    public double[] psi() {
        return this.enum != null ? Arrays.copyOf(this.enum, this.enum.length) : null;
    }

    public double mu() {
        return this.catch;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }
}

