/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.variance;

import dev.nm.stat.descriptive.moment.Variance;
import dev.nm.stat.distribution.univariate.ChiSquareDistribution;
import dev.nm.stat.test.HypothesisTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Bartlett
extends HypothesisTest {
    private final double enum;

    @Override
    public String getAlternativeHypothesis() {
        return "at least two variances are different";
    }

    public Bartlett(double[] ... samples) {
        super(samples);
        int a2 = this.nObs();
        int a3 = this.nGroups();
        double a4 = 0.0;
        double[] a5 = new double[a3];
        for (int a6 = 0; a6 < a3; ++a6) {
            a5[a6] = new Variance(samples[a6]).value();
            a4 += (double)(samples[a6].length - 1) * a5[a6];
        }
        a4 /= (double)(a2 - a3);
        double a7 = 0.0;
        double a8 = 0.0;
        for (int a9 = 0; a9 < a3; ++a9) {
            a7 += (double)(samples[a9].length - 1) * Math.log(a5[a9]);
            a8 += 1.0 / (double)(samples[a9].length - 1);
        }
        this.enum = ((double)(a2 - a3) * Math.log(a4) - a7) / (1.0 + (a8 - 1.0 / (double)(a2 - a3)) / (double)(3 * (a3 - 1)));
    }

    @Override
    public double pValue() {
        int a2 = this.nGroups();
        int a3 = a2 - 1;
        ChiSquareDistribution a4 = new ChiSquareDistribution(a3);
        double a5 = Bartlett.oneSidedPvalue(a4, this.enum);
        return a5;
    }

    @Override
    public String getNullHypothesis() {
        return "all population variances are equal";
    }

    @Override
    public double statistics() {
        return this.enum;
    }
}

