/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.lasso.lars;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.license.Package;
import dev.nm.stat.descriptive.moment.Mean;
import dev.nm.stat.regression.linear.LMProblem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LARSProblem
extends LMProblem {
    private final boolean goto;
    private final boolean enum;

    public double yMean() {
        if (this.intercept()) {
            double a2 = new Mean(this.y().toArray()).value();
            return a2;
        }
        return 0.0;
    }

    public LARSProblem(Vector y, Matrix X, boolean intercept, boolean normalized, boolean lasso) {
        super(y, X, intercept);
        this.goto = normalized;
        this.enum = lasso;
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    public Vector yLARS() {
        Vector a2 = this.y().minus(this.yMean());
        return a2;
    }

    public LARSProblem(Vector y, Matrix X, boolean lasso) {
        this(y, X, true, lasso);
    }

    public Vector XL2Norm() {
        int a2 = this.m();
        ImmutableMatrix a3 = this.X();
        double[] a4 = new double[a2];
        for (int a5 = 0; a5 < a2; ++a5) {
            double a6;
            a4[a5] = this.goto ? (a6 = a3.getColumn(a5 + 1).norm()) : 1.0;
        }
        DenseVector a7 = new DenseVector(a4);
        return a7;
    }

    public Matrix XLARS() {
        int a2 = this.nObs();
        int a3 = this.m();
        ImmutableMatrix a4 = this.X();
        Vector a5 = this.XMean();
        Vector a6 = this.XL2Norm();
        DenseMatrix a7 = new DenseMatrix(a2, a3);
        for (int a8 = 1; a8 <= a3; ++a8) {
            Vector a9 = a4.getColumn(a8).minus(a5.get(a8)).scaled(1.0 / a6.get(a8));
            for (int a10 = 1; a10 <= a2; ++a10) {
                a7.set(a10, a8, a9.get(a10));
            }
        }
        return a7;
    }

    public int m() {
        int a2 = this.nFactors() - (this.intercept() ? 1 : 0);
        return a2;
    }

    public LARSProblem(LARSProblem that) {
        super(that);
        this.goto = that.goto;
        this.enum = that.enum;
    }

    public LARSProblem(Vector y, Matrix X) {
        this(y, X, true);
    }

    public LARSProblem(Vector y, Matrix X, boolean normalized, boolean lasso) {
        this(y, X, true, normalized, lasso);
    }

    public boolean isLASSO() {
        return this.enum;
    }

    public Vector XMean() {
        int a2 = this.m();
        if (!this.intercept()) {
            return new DenseVector(a2);
        }
        ImmutableMatrix a3 = this.X();
        DenseVector a4 = new DenseVector(a2);
        for (int a5 = 1; a5 <= a2; ++a5) {
            double a6 = new Mean(a3.getColumn(a5).toArray()).value();
            a4.set(a5, a6);
        }
        return a4;
    }
}

