/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.hmm.mixture.distribution;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.hmm.mixture.distribution.MixtureDistribution;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import dev.nm.stat.random.rng.univariate.normal.NormalRNG;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NormalMixtureDistribution
implements MixtureDistribution {
    private final boolean class;
    private final Lambda[] goto;
    private final boolean enum;

    @Override
    public ProbabilityDistribution[] newDistributions() {
        ProbabilityDistribution[] a2 = new ProbabilityDistribution[this.goto.length];
        for (int a3 = 0; a3 < this.goto.length; ++a3) {
            double a4 = this.goto[a3].mu;
            double a5 = this.goto[a3].sigma;
            a2[a3] = new NormalDistribution(a4, a5);
        }
        return a2;
    }

    @Override
    public MixtureDistribution newMixtureDistribution(Object[] param) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param, param.length);
        return new NormalMixtureDistribution(a2, this.enum, this.class);
    }

    public Lambda[] getMStepParams(double[] observations, Vector[] u) {
        int a2 = u.length;
        int a3 = u[0].size();
        Lambda[] a4 = new Lambda[this.goto.length];
        for (int a5 = 0; a5 < a3; ++a5) {
            double a6;
            double a7;
            double a8 = this.goto[a5].mu;
            if (this.enum) {
                a7 = 0.0;
                a6 = 0.0;
                for (int a9 = 0; a9 < a2; ++a9) {
                    double a10 = u[a9].get(a5 + 1);
                    a7 += a10 * observations[a9];
                    a6 += a10;
                }
                a8 = a7 / a6;
            }
            a7 = this.goto[a5].sigma;
            if (this.class) {
                a6 = 0.0;
                double a11 = 0.0;
                for (int a12 = 0; a12 < a2; ++a12) {
                    double a13 = u[a12].get(a5 + 1);
                    double a14 = observations[a12] - a8;
                    a6 += a13 * a14 * a14;
                    a11 += a13;
                }
                a7 = Math.sqrt(a6 / a11);
            }
            a4[a5] = new Lambda(a8, a7);
        }
        return a4;
    }

    public NormalMixtureDistribution(Lambda[] lambda) {
        this(lambda, true, true);
    }

    public Lambda[] getParams() {
        Lambda[] a2 = Arrays.copyOf(this.goto, this.goto.length);
        return a2;
    }

    @Override
    public RandomNumberGenerator[] newRandomNumberGenerators() {
        RandomNumberGenerator[] a2 = new RandomNumberGenerator[this.goto.length];
        for (int a3 = 0; a3 < this.goto.length; ++a3) {
            double a4 = this.goto[a3].mu;
            double a5 = this.goto[a3].sigma;
            a2[a3] = new NormalRNG(a4, a5);
        }
        return a2;
    }

    public NormalMixtureDistribution(Lambda[] lambda, boolean isMuEstimated, boolean isSigmaEstimated) {
        this.goto = Arrays.copyOf(lambda, lambda.length);
        this.enum = isMuEstimated;
        this.class = isSigmaEstimated;
    }

    public static class Lambda {
        public final double mu;
        public final double sigma;

        public Lambda(double mu, double sigma) {
            this.mu = mu;
            this.sigma = sigma;
        }
    }
}

