/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.bivariate;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.root.univariate.BrentRoot;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.analysis.root.univariate.Uniroot;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.misc.license.Package;
import dev.nm.stat.evt.evd.bivariate.AbstractBivariateEVD;
import dev.nm.stat.evt.evd.univariate.GeneralizedEVD;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDNegativeLogistic
extends AbstractBivariateEVD {
    private final UniformRNG const = new UniformRNG();
    private static final Uniroot void;
    private final GeneralizedEVD class;
    private final GeneralizedEVD goto;
    private final double enum;

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.class.marginalTransform(x1);
        double a3 = this.goto.marginalTransform(x2);
        double a4 = a2 + a3 - Math.pow(Math.pow(a2, -this.enum) + Math.pow(a3, -this.enum), -1.0 / this.enum);
        return Math.exp(-a4);
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.do(x1, x2);
    }

    private double do(double a2, double a3) {
        BivariateEVDNegativeLogistic a4;
        double a5 = -Math.log(a2);
        double a6 = -Math.log(a3);
        double a7 = 1.0 / a4.enum;
        double a8 = Math.pow(Math.pow(a6, -a4.enum) + Math.pow(a5, -a4.enum), -a7);
        double a9 = Math.exp(a8) * a2 * (1.0 - Math.pow(1.0 + Math.pow(a6 / a5, a4.enum), -1.0 - a7));
        return a9;
    }

    public BivariateEVDNegativeLogistic(double dependence) {
        this(dependence, new GeneralizedEVD());
    }

    @Override
    public void seed(long ... seeds) {
        this.const.seed(seeds);
    }

    @Override
    public double[] nextVector() {
        double a2;
        final double[] a3 = new double[]{this.const.nextDouble(), this.const.nextDouble()};
        AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){
            {
                1 a32;
            }

            @Override
            public double evaluate(double x) {
                return BivariateEVDNegativeLogistic.this.do(x, a3[1]) - a3[0];
            }
        };
        try {
            a2 = void.solve(a4, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a5) {
            a2 = a5.x();
        }
        a3[0] = a2;
        double a6 = this.class.marginalInverseTransform(-Math.log(a3[0]));
        double a7 = this.goto.marginalInverseTransform(-Math.log(a3[1]));
        return new double[]{a6, a7};
    }

    static {
        Package.validate("NMDEV_EVT");
        void = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }

    public BivariateEVDNegativeLogistic(double dependence, GeneralizedEVD marginal) {
        this(dependence, marginal, marginal);
    }

    @Override
    public double density(double x1, double x2) {
        double a2 = this.class.marginalTransform(x1);
        double a3 = this.goto.marginalTransform(x2);
        if (a2 == 0.0 || a3 == 0.0 || Double.isInfinite(a2) || Double.isInfinite(a3)) {
            return 0.0;
        }
        double a4 = 1.0 / this.enum;
        double a5 = Math.pow(Math.pow(a2, -this.enum) + Math.pow(a3, -this.enum), -a4);
        double a6 = a2 + a3 - a5;
        double a7 = Math.log(a2);
        double a8 = Math.log(a3);
        double a9 = (-this.enum - 1.0) * a7;
        double a10 = (-this.enum - 1.0) * a8;
        double a11 = (1.0 + this.class.getShape()) * a7 + (1.0 + this.goto.getShape()) * a8 - Math.log(this.class.getScale() * this.goto.getScale());
        double a12 = (1.0 + this.enum) * Math.log(a5) + Math.log(Math.exp(a9) + Math.exp(a10));
        double a13 = a9 + a10 + (1.0 + 2.0 * this.enum) * Math.log(a5) + Math.log(1.0 + this.enum + a5);
        double a14 = Math.log(1.0 - Math.exp(a12) + Math.exp(a13)) - a6 + a11;
        return Math.exp(a14);
    }

    public BivariateEVDNegativeLogistic(double dependence, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertPositive(dependence, "dependence");
        this.enum = dependence;
        this.class = marginal1;
        this.goto = marginal2;
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return (1.0 + this.enum) * Math.pow(x * (1.0 - x), this.enum - 1.0) * Math.pow(Math.pow(x, this.enum) + Math.pow(1.0 - x, this.enum), -1.0 / this.enum - 2.0);
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return 1.0 - Math.pow(Math.pow(x, -this.enum) + Math.pow(1.0 - x, -this.enum), -1.0 / this.enum);
    }
}

