/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.bivariate;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.root.univariate.BrentRoot;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.analysis.root.univariate.Uniroot;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.misc.license.Package;
import dev.nm.stat.evt.evd.bivariate.AbstractBivariateEVD;
import dev.nm.stat.evt.evd.univariate.GeneralizedEVD;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDAsymmetricMixed
extends AbstractBivariateEVD {
    private final GeneralizedEVD catch;
    private final UniformRNG const = new UniformRNG();
    private final GeneralizedEVD void;
    private final double class;
    private final double goto;
    private static final Uniroot enum;

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return 1.0 - (this.class + this.goto) * x + this.class * x * x + this.goto * x * x * x;
    }

    public BivariateEVDAsymmetricMixed(double alpha, double beta) {
        this(alpha, beta, new GeneralizedEVD());
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.do(x1, x2);
    }

    @Override
    public void seed(long ... seeds) {
        this.const.seed(seeds);
    }

    @Override
    public double[] nextVector() {
        double a2;
        final double[] a3 = new double[]{this.const.nextDouble(), this.const.nextDouble()};
        AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return BivariateEVDAsymmetricMixed.this.do(x, a3[1]) - a3[0];
            }
            {
                1 a32;
            }
        };
        try {
            a2 = enum.solve(a4, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a5) {
            a2 = a5.x();
        }
        a3[0] = a2;
        double a6 = this.catch.marginalInverseTransform(-Math.log(a3[0]));
        double a7 = this.void.marginalInverseTransform(-Math.log(a3[1]));
        return new double[]{a6, a7};
    }

    public BivariateEVDAsymmetricMixed(double alpha, double beta, GeneralizedEVD marginal) {
        this(alpha, beta, marginal, marginal);
    }

    private double do(double a2, double a3) {
        BivariateEVDAsymmetricMixed a4;
        double a5 = -Math.log(a2);
        double a6 = -Math.log(a3);
        double a7 = a5 / (a5 + a6);
        double a8 = a5 + a6 - a5 * (a4.class + a4.goto - a4.class * a7 - a4.goto * a7 * a7);
        double a9 = 1.0 - a4.class * a7 * a7 - 2.0 * a4.goto * a7 * a7 * a7;
        double a10 = Math.exp(-a8) * (1.0 / a3) * a9;
        return a10;
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        return 2.0 * this.class + 6.0 * this.goto * (1.0 - x);
    }

    static {
        Package.validate("NMDEV_EVT");
        enum = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.catch.marginalTransform(x1);
        double a4 = this.void.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            double a5 = a3 + a4;
            double a6 = a5 - (this.class + this.goto) * a3 + this.class * a3 * a3 / a5 + this.goto * a3 * a3 * a3 / a5 / a5;
            double a7 = Math.log(a3);
            double a8 = Math.log(a4);
            double a9 = (1.0 + this.catch.getShape()) * a7 + (1.0 + this.void.getShape()) * a8 - Math.log(this.catch.getScale() * this.void.getScale());
            double a10 = a3 / a5;
            double a11 = a4 / a5;
            double a12 = 1.0 - this.class * a11 * a11 - this.goto * (3.0 * a11 * a11 - 2.0 * a11 * a11 * a11);
            double a13 = 1.0 - this.class * a10 * a10 - 2.0 * this.goto * a10 * a10 * a10;
            double a14 = (-2.0 * this.class * a10 * a11 - 6.0 * this.goto * a10 * a10 * a11) / a5;
            a2 = Math.log(a12 * a13 - a14) - a6 + a9;
        }
        return Math.exp(a2);
    }

    public BivariateEVDAsymmetricMixed(double alpha, double beta, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertNonNegative(alpha, "alpha");
        ArgumentAssertion.assertNotGreaterThan(alpha + beta, 1.0, "alpha + beta");
        ArgumentAssertion.assertNotGreaterThan(alpha + 2.0 * beta, 1.0, "alpha + 2*beta");
        ArgumentAssertion.assertNonNegative(alpha + 3.0 * beta, "alpha + 3*beta");
        this.class = alpha;
        this.goto = beta;
        this.catch = marginal1;
        this.void = marginal2;
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.catch.marginalTransform(x1);
        double a3 = this.void.marginalTransform(x2);
        if (Double.isInfinite(a2) || Double.isInfinite(a3)) {
            return 0.0;
        }
        double a4 = a2 + a3;
        if (a4 == 0.0) {
            return 1.0;
        }
        double a5 = a2 * a2;
        double a6 = a4 - (this.class + this.goto) * a2 + this.class * a5 / a4 + this.goto * a5 * a2 / a4 / a4;
        return Math.exp(-a6);
    }
}

