/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.bivariate;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.ExponentialDistribution;
import dev.nm.stat.evt.evd.bivariate.AbstractBivariateEVD;
import dev.nm.stat.evt.evd.univariate.GeneralizedEVD;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDAsymmetricLogistic
extends AbstractBivariateEVD {
    private final UniformRNG else = new UniformRNG();
    private final double catch;
    private final double const;
    private final double void;
    private final GeneralizedEVD class;
    private static final ExponentialDistribution goto;
    private final GeneralizedEVD enum;

    public BivariateEVDAsymmetricLogistic(double dependence, double asymmetry1, double asymmetry2, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertRangeLeftOpen(dependence, 0.0, 1.0, "dependence");
        ArgumentAssertion.assertRange(asymmetry1, 0.0, 1.0, "asymmetry1");
        ArgumentAssertion.assertRange(asymmetry2, 0.0, 1.0, "asymmetry2");
        this.void = dependence;
        this.catch = asymmetry1;
        this.const = asymmetry2;
        this.class = marginal1;
        this.enum = marginal2;
    }

    @Override
    public double[] nextVector() {
        if (this.void == 1.0 || this.catch == 0.0 || this.const == 0.0) {
            return this.do(1.0, 0.0, 0.0);
        }
        return this.do(this.void, this.catch, this.const);
    }

    public BivariateEVDAsymmetricLogistic(double dependence, double asymmetry1, double asymmetry2, GeneralizedEVD marginal) {
        this(dependence, asymmetry1, asymmetry2, marginal, marginal);
    }

    private double do() {
        BivariateEVDAsymmetricLogistic a2;
        double a3 = a2.else.nextDouble();
        return goto.quantile(a3);
    }

    public BivariateEVDAsymmetricLogistic(double dependence, double asymmetry1, double asymmetry2) {
        this(dependence, asymmetry1, asymmetry2, new GeneralizedEVD());
    }

    @Override
    public void seed(long ... seeds) {
        this.else.seed(seeds);
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = 1.0 / this.void;
        return Math.pow(Math.pow(this.catch * x, a2) + Math.pow(this.const * (1.0 - x), a2), this.void) + (1.0 - this.catch) * x + (1.0 - this.const) * (1.0 - x);
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        double a2 = x1;
        double a3 = x2;
        double a4 = this.catch;
        double a5 = this.const;
        double a6 = -Math.log(a2);
        double a7 = -Math.log(a3);
        double a8 = 1.0 / this.void;
        double a9 = Math.pow(a4 * a6, a8) + Math.pow(a5 * a7, a8);
        double a10 = (1.0 - a4) * a6 + (1.0 - a5) * a7 + Math.pow(a9, this.void);
        double a11 = Math.exp(-a10) * (1.0 / a3) * (1.0 - a5 + Math.pow(a5, a8) * Math.pow(a7, a8 - 1.0) * Math.pow(a9, this.void - 1.0));
        return a11;
    }

    private double[] do(double a2, double a3, double a4) {
        double a5;
        BivariateEVDAsymmetricLogistic a6;
        double[] a7 = new double[2];
        if (a2 == 1.0) {
            for (int a8 = 0; a8 < 2; ++a8) {
                a7[a8] = 1.0 / a6.do();
            }
        } else {
            double a9 = (1.0 - a3) / a6.do();
            a5 = (1.0 - a4) / a6.do();
            double a10 = a6.else.nextDouble();
            double a11 = a6.else.nextDouble() < a2 ? a6.do() + a6.do() : a6.do();
            double a12 = a3 / (a11 * Math.pow(a10, a2));
            double a13 = a4 / (a11 * Math.pow(1.0 - a10, a2));
            a7[0] = Math.max(a9, a12);
            a7[1] = Math.max(a5, a13);
        }
        double a14 = a6.class.marginalInverseTransform(1.0 / a7[0]);
        a5 = a6.enum.marginalInverseTransform(1.0 / a7[1]);
        return new double[]{a14, a5};
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = 1.0 / this.void;
        return (a2 - 1.0) * Math.pow(this.catch * this.const, a2) * Math.pow(x * (1.0 - x), -1.0 - a2) * Math.pow(Math.pow(this.catch / x, a2) + Math.pow(this.const / (1.0 - x), a2), this.void - 2.0);
    }

    public BivariateEVDAsymmetricLogistic(double dependence) {
        this(dependence, 1.0, 1.0);
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.class.marginalTransform(x1);
        double a3 = this.enum.marginalTransform(x2);
        double a4 = this.catch;
        double a5 = this.const;
        double a6 = Math.pow(Math.pow(a2 * a4, 1.0 / this.void) + Math.pow(a3 * a5, 1.0 / this.void), this.void) + a2 * (1.0 - a4) + a3 * (1.0 - a5);
        double a7 = Math.exp(-a6);
        return a7;
    }

    static {
        Package.validate("NMDEV_EVT");
        goto = new ExponentialDistribution();
    }

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.class.marginalTransform(x1);
        double a4 = this.enum.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            double a5 = 1.0 / this.void;
            double a6 = Math.pow(Math.pow(a3 * this.catch, a5) + Math.pow(a4 * this.const, a5), this.void);
            double a7 = a6 + (1.0 - this.catch) * a3 + (1.0 - this.const) * a4;
            double a8 = a5 * Math.log(this.catch);
            double a9 = a5 * Math.log(this.const);
            double a10 = Math.log(1.0 - this.catch);
            double a11 = Math.log(1.0 - this.const);
            double a12 = Math.log(a3);
            double a13 = Math.log(a4);
            double a14 = (a5 - 1.0) * a12;
            double a15 = (a5 - 1.0) * a13;
            double a16 = (1.0 + this.class.getShape()) * a12 + (1.0 + this.enum.getShape()) * a13 - Math.log(this.class.getScale() * this.enum.getScale());
            double a17 = a10 + a11;
            double a18 = a10 + a9 + a15;
            double a19 = a11 + a8 + a14;
            double a20 = (1.0 - a5) * Math.log(a6) + Math.log(Math.exp(a18) + Math.exp(a19));
            double a21 = a8 + a9 + a14 + a15 + (1.0 - 2.0 * a5) * Math.log(a6) + Math.log(a5 - 1.0 + a6);
            a2 = Math.log(Math.exp(a17) + Math.exp(a20) + Math.exp(a21)) - a7 + a16;
        }
        return Math.exp(a2);
    }
}

