/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.dlm.multivariate;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskyWang2006;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.matrix.doubles.operation.SimilarMatrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.matrix.R1toConstantMatrix;
import dev.nm.analysis.function.matrix.R1toMatrix;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.stat.dlm.univariate.ObservationEquation;
import dev.nm.stat.random.rng.multivariate.NormalRVG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateObservationEquation {
    private final int void;
    private final NormalRVG class;
    private final R1toMatrix goto;
    private final R1toMatrix enum;

    public MultivariateObservationEquation(Matrix F2, Matrix V) {
        this(new R1toConstantMatrix(F2), new R1toConstantMatrix(V), null);
    }

    public ImmutableVector yt_mean(int t, Vector xt) {
        Vector a2 = this.enum.evaluate(t).multiply(xt);
        return new ImmutableVector(a2);
    }

    public int dimension() {
        return this.void;
    }

    public MultivariateObservationEquation(R1toMatrix F2, R1toMatrix V, NormalRVG rmvnorm) {
        this.void = F2.evaluate(1.0).nRows();
        ArgumentAssertion.assertTrue(V.evaluate(1.0).nRows() == this.void && V.evaluate(1.0).nCols() == this.void, "the dimension of V is the same as the dimension of observation y_t", new Object[0]);
        this.enum = F2;
        this.goto = V;
        this.class = rmvnorm == null ? new NormalRVG(this.void) : rmvnorm;
    }

    public ImmutableMatrix V(int t) {
        return new ImmutableMatrix(this.goto.evaluate(t));
    }

    public MultivariateObservationEquation(final ObservationEquation obs) {
        this(new R1toMatrix(){

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{obs.F((int)t)}});
            }
            {
                1 a2;
            }
        }, new R1toMatrix(){
            {
                2 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{obs.V((int)t)}});
            }
        });
    }

    public MultivariateObservationEquation(MultivariateObservationEquation that) {
        this(that.enum, that.goto);
    }

    public ImmutableVector yt(int t, Vector xt) {
        Vector a2 = this.yt_mean(t, xt);
        Matrix a3 = this.goto.evaluate(t);
        LowerTriangularMatrix a4 = new CholeskyWang2006(a3, PrecisionUtils.autoEpsilon(MatrixUtils.to1DArray(a3))).L();
        Vector a5 = a4.multiply(new DenseVector(this.class.nextVector()));
        a2 = a2.add(a5);
        return new ImmutableVector(a2);
    }

    public MultivariateObservationEquation(Matrix F2, Matrix V, NormalRVG rmvnorm) {
        this(new R1toConstantMatrix(F2), new R1toConstantMatrix(V), rmvnorm);
    }

    public ImmutableMatrix yt_var(int t, Matrix var_t_tlag) {
        ImmutableMatrix a2 = this.F(t);
        ImmutableMatrix a3 = this.V(t);
        Matrix a4 = new SimilarMatrix(a2.t(), var_t_tlag).add(a3);
        return new ImmutableMatrix(a4);
    }

    public ImmutableMatrix F(int t) {
        return new ImmutableMatrix(this.enum.evaluate(t));
    }

    public MultivariateObservationEquation(R1toMatrix F2, R1toMatrix V) {
        this(F2, V, null);
    }
}

