/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.misc.Constants;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TriangularDistribution
implements ProbabilityDistribution {
    private final double class;
    private final double goto;
    private final double enum;

    @Override
    public double quantile(double u) {
        if (u <= (this.class - this.goto) / (this.enum - this.goto)) {
            return this.goto + Math.sqrt(u * (this.enum - this.goto) * (this.class - this.goto));
        }
        return this.enum - Math.sqrt((1.0 - u) * (this.enum - this.goto) * (this.enum - this.class));
    }

    @Override
    public double density(double x) {
        if (x < this.goto || x > this.enum) {
            return 0.0;
        }
        if (this.goto <= x && x <= this.class) {
            return 2.0 * (x - this.goto) / ((this.enum - this.goto) * (this.class - this.goto));
        }
        return 2.0 * (this.enum - x) / ((this.enum - this.goto) * (this.enum - this.class));
    }

    @Override
    public double kurtosis() {
        return -0.6;
    }

    @Override
    public double entropy() {
        double a2 = 0.5;
        return a2 += Math.log((this.enum - this.goto) / 2.0);
    }

    public TriangularDistribution(double min, double mode, double max) {
        this.goto = min;
        this.class = mode;
        this.enum = max;
    }

    @Override
    public double variance() {
        double a2 = this.goto * this.goto + this.enum * this.enum + this.class * this.class - this.goto * this.enum - this.goto * this.class - this.enum * this.class;
        return a2 /= 18.0;
    }

    @Override
    public double median() {
        double a2 = (this.goto + this.enum) / 2.0;
        if (this.class >= a2) {
            double a3 = (this.enum - this.goto) * (this.class - this.goto) / 2.0;
            a3 = Math.sqrt(a3);
            return a3 += this.goto;
        }
        double a4 = (this.enum - this.goto) * (this.enum - this.class) / 2.0;
        a4 = Math.sqrt(a4);
        a4 = this.enum - a4;
        return a4;
    }

    @Override
    public double moment(double t) {
        double a2 = 2.0 * (this.enum - this.class) * Math.exp(this.goto * t);
        a2 -= (this.enum - this.goto) * Math.exp(this.class * t);
        a2 -= (this.class - this.goto) * Math.exp(this.enum * t);
        return a2 /= (this.enum - this.goto) * (this.class - this.goto) * (this.enum - this.class) / t / t;
    }

    @Override
    public double skew() {
        double a2 = Constants.ROOT_2;
        a2 *= (this.goto + this.enum - 2.0 * this.class) * (2.0 * this.goto - this.enum - this.class) * (this.goto - 2.0 * this.enum + this.class);
        a2 /= Math.pow(this.goto * this.goto + this.enum * this.enum + this.class * this.class - this.goto * this.enum - this.goto * this.class - this.enum * this.class, 1.5);
        return a2 /= 5.0;
    }

    @Override
    public double cdf(double x) {
        if (x < this.goto) {
            return 0.0;
        }
        if (this.goto <= x && x <= this.class) {
            return (x - this.goto) * (x - this.goto) / ((this.enum - this.goto) * (this.class - this.goto));
        }
        if (this.class < x && x <= this.enum) {
            return 1.0 - (this.enum - x) * (this.enum - x) / ((this.enum - this.goto) * (this.enum - this.class));
        }
        return 1.0;
    }

    @Override
    public double mean() {
        double a2 = this.goto + this.enum + this.class;
        return a2 /= 3.0;
    }
}

