/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.beta.BetaRegularized;
import dev.nm.analysis.function.special.beta.BetaRegularizedInverse;
import dev.nm.analysis.function.special.beta.LogBeta;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.ExceptionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FDistribution
implements ProbabilityDistribution {
    private final double const;
    private final BetaRegularized void;
    private final BetaRegularizedInverse class;
    private static final LogBeta goto = new LogBeta();
    private final double enum;

    @Override
    public double cdf(double x) {
        ArgumentAssertion.assertNonNegative(x, "x");
        return this.void.evaluate(this.enum * x / (this.enum * x + this.const));
    }

    @Override
    public double density(double x) {
        ArgumentAssertion.assertNonNegative(x, "x");
        if (DoubleUtils.isZero(x, 0.0)) {
            if (this.enum < 2.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.enum == 2.0) {
                return 1.0;
            }
            return 0.0;
        }
        double a2 = this.enum * Math.log(this.enum * x);
        a2 += this.const * Math.log(this.const);
        a2 -= (this.enum + this.const) * Math.log(this.enum * x + this.const);
        a2 /= 2.0;
        a2 -= Math.log(x);
        a2 -= goto.evaluate(this.enum / 2.0, this.const / 2.0);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double skew() {
        ExceptionUtils.throwIfNotNull(this.const > 6.0 ? null : new UnsupportedOperationException("only supported for df2 > 6"));
        double a2 = (2.0 * this.enum + this.const - 2.0) * Math.sqrt(8.0 * (this.const - 4.0));
        return a2 /= (this.const - 6.0) * Math.sqrt(this.enum * (this.enum + this.const - 2.0));
    }

    @Override
    public double quantile(double u) {
        double a2 = this.class.evaluate(u);
        return this.const * a2 / (this.enum - this.enum * a2);
    }

    @Override
    public double mean() {
        ExceptionUtils.throwIfNotNull(this.const > 2.0 ? null : new UnsupportedOperationException("only supported for df2 > 2"));
        return this.const / (this.const - 2.0);
    }

    @Override
    public double variance() {
        ExceptionUtils.throwIfNotNull(this.const > 4.0 ? null : new UnsupportedOperationException("only supported for df2 > 4"));
        double a2 = 2.0 * this.const * this.const * (this.enum + this.const - 2.0);
        return a2 /= this.enum * (this.const - 2.0) * (this.const - 2.0) * (this.const - 4.0);
    }

    @Override
    @Deprecated
    public double median() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FDistribution(double df1, double df2) {
        ArgumentAssertion.assertPositive(df1, "df1");
        ArgumentAssertion.assertPositive(df2, "df2");
        this.enum = df1;
        this.const = df2;
        this.void = new BetaRegularized(df1 / 2.0, df2 / 2.0);
        this.class = new BetaRegularizedInverse(df1 / 2.0, df2 / 2.0);
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double kurtosis() {
        ExceptionUtils.throwIfNotNull(this.const > 8.0 ? null : new UnsupportedOperationException("only supported for df2 > 8"));
        double a2 = 5.0 * this.const * this.const * this.enum - 22.0 * this.enum * this.enum + 5.0 * this.const * this.enum * this.enum - 16.0;
        double a3 = 20.0 * this.const - 8.0 * this.const * this.const + this.const * this.const * this.const + 44.0 * this.enum - 32.0 * this.enum * this.const + a2;
        return (a3 /= this.enum * (this.const - 6.0) * (this.const - 8.0) * (this.enum + this.const - 2.0) / 12.0) - 3.0;
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("does not exist.");
    }
}

