/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.gamma.Digamma;
import dev.nm.analysis.function.special.gamma.GammaRegularizedP;
import dev.nm.analysis.function.special.gamma.GammaRegularizedPInverse;
import dev.nm.analysis.function.special.gamma.LogGamma;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ChiSquareDistribution
implements ProbabilityDistribution {
    private static final GammaRegularizedPInverse const;
    private static final Digamma void;
    private static final GammaRegularizedP class;
    private static final LogGamma goto;
    private final double enum;

    public ChiSquareDistribution(double k2) {
        ArgumentAssertion.assertPositive(k2, "k");
        this.enum = k2;
    }

    @Override
    public double entropy() {
        return this.enum / 2.0 + Math.log(2.0) + goto.evaluate(this.enum / 2.0) + (1.0 - this.enum / 2.0) * void.evaluate(this.enum / 2.0);
    }

    @Override
    public double quantile(double u) {
        return 2.0 * const.evaluate(this.enum / 2.0, u);
    }

    @Override
    public double moment(double t) {
        ArgumentAssertion.assertLessThan(t, 0.5, "t");
        return Math.pow(1.0 - 2.0 * t, -this.enum / 2.0);
    }

    @Override
    public double kurtosis() {
        return 12.0 / this.enum;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.enum < 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.enum == 2.0) {
            return 0.5;
        }
        double a2 = Math.pow(0.5, this.enum / 2.0);
        double a3 = (this.enum / 2.0 - 1.0) * Math.log(x) - x / 2.0 - goto.evaluate(this.enum / 2.0);
        return a2 *= Math.exp(a3);
    }

    @Override
    public double median() {
        return this.enum - 0.0 + 0.0 / this.enum - 0.0 / this.enum / this.enum;
    }

    @Override
    public double skew() {
        return Math.sqrt(8.0 / this.enum);
    }

    @Override
    public double mean() {
        return this.enum;
    }

    static {
        goto = new LogGamma();
        ChiSquareDistribution.class = new GammaRegularizedP();
        const = new GammaRegularizedPInverse();
        void = new Digamma();
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return ChiSquareDistribution.class.evaluate(this.enum / 2.0, x / 2.0);
    }

    @Override
    public double variance() {
        return 2.0 * this.enum;
    }
}

