/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.rank;

import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Rank {
    private final double class;
    private final double[] goto;
    private final double enum;

    public double rank(int i2) {
        return this.goto[i2];
    }

    public double s() {
        return this.class;
    }

    private int[] do(double[] a4) {
        int a5 = a4.length;
        Entry[] a6 = new Entry[a5];
        for (int a7 = 0; a7 < a5; ++a7) {
            a6[a7] = new Entry(a7, a4[a7]);
        }
        Arrays.sort(a6, (a2, a3) -> Double.compare(((Entry)a2).enum, ((Entry)a3).enum));
        int[] a8 = new int[a5];
        for (int a9 = 0; a9 < a5; ++a9) {
            a8[a9] = a6[a9].goto;
            a4[a9] = a6[a9].enum;
        }
        return a8;
    }

    public Rank(double[] values, double threshold) {
        this(values, threshold, TiesMethod.AS_26);
    }

    public double t() {
        return this.enum;
    }

    public Rank(double[] values, TiesMethod tiesMethod) {
        this(values, PrecisionUtils.autoEpsilon(values), tiesMethod);
    }

    public double[] ranks() {
        return Arrays.copyOf(this.goto, this.goto.length);
    }

    public Rank(double[] values) {
        this(values, PrecisionUtils.autoEpsilon(values));
    }

    public Rank(double[] values, double threshold, TiesMethod tiesMethod) {
        int a2;
        double a3 = 0.0;
        double a4 = 0.0;
        int a5 = values.length;
        double[] a6 = Arrays.copyOf(values, a5);
        int[] a7 = this.do(a6);
        double[] a8 = new double[a5];
        a8[a5 - 1] = a5 - 1;
        for (a2 = 0; a2 < a5 - 1; ++a2) {
            if (Math.abs(a6[a2] - a6[a2 + 1]) > threshold) {
                a8[a2] = a2;
                continue;
            }
            int a9 = 2;
            for (int a10 = a2 + 1; a10 < a5 - 1 && Math.abs(a6[a10] - a6[a10 + 1]) < threshold; ++a10) {
                ++a9;
            }
            double[] a11 = tiesMethod.ranksForTies(a2, a9);
            for (int a12 = 0; a12 < a9; ++a12) {
                a8[a2 + a12] = a11[a12];
            }
            double a13 = (a9 - 1) * a9;
            a4 += a13;
            a3 += a13 * (double)(a9 + 1);
            a2 += a9 - 1;
        }
        this.class = a4;
        this.enum = a3;
        this.goto = new double[a5];
        for (a2 = 0; a2 < a5; ++a2) {
            this.goto[a7[a2]] = a8[a2] + 1.0;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum TiesMethod {
        AS_26{
            {
                1 a2;
            }

            @Override
            double[] ranksForTies(int a2, int a3) {
                return TiesMethod.do(a3, (double)a2 + 0.5 * (double)(a3 - 1));
            }
        }
        ,
        AVERAGE{

            @Override
            double[] ranksForTies(int a2, int a3) {
                return TiesMethod.do(a3, (double)a2 + 0.5 * (double)(a3 - 1));
            }
            {
                2 a2;
            }
        }
        ,
        FIRST{

            @Override
            double[] ranksForTies(int a2, int a3) {
                return DoubleUtils.seq(a3, (double)a2, 1.0);
            }
            {
                3 a2;
            }
        }
        ,
        LAST{

            @Override
            double[] ranksForTies(int a2, int a3) {
                return DoubleUtils.seq(a3, (double)(a2 + a3 - 1), -1.0);
            }
            {
                4 a2;
            }
        }
        ,
        RANDOM{
            {
                5 a2;
            }

            @Override
            double[] ranksForTies(int a2, int a3) {
                ArrayList<Double> a4 = new ArrayList<Double>(a3);
                for (int a5 = 0; a5 < a3; ++a5) {
                    a4.add(Double.valueOf(a2 + a5));
                }
                Collections.shuffle(a4);
                double[] a6 = DoubleUtils.collection2DoubleArray(a4);
                return a6;
            }
        }
        ,
        MAX{
            {
                6 a2;
            }

            @Override
            double[] ranksForTies(int a2, int a3) {
                return TiesMethod.do(a3, a2 + a3 - 1);
            }
        }
        ,
        MIN{

            @Override
            double[] ranksForTies(int a2, int a3) {
                return TiesMethod.do(a3, a2);
            }
            {
                7 a2;
            }
        };


        abstract double[] ranksForTies(int var1, int var2);

        private static double[] do(int a2, double a3) {
            return DoubleUtils.rep(a3, a2);
        }

        private TiesMethod() {
            TiesMethod a2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Entry {
        private final int goto;
        private final double enum;

        private Entry(int a2, double a3) {
            Entry a4;
            a4.goto = a2;
            a4.enum = a3;
        }
    }
}

