/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.moment.weighted;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.number.doublearray.DoubleArrayOperation;
import dev.nm.number.doublearray.SimpleDoubleArrayOperation;
import dev.nm.stat.descriptive.Statistic;
import dev.nm.stat.descriptive.moment.weighted.WeightedMean;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WeightedVariance
implements Statistic {
    private double[] catch;
    private double const;
    private static DoubleArrayOperation void = new SimpleDoubleArrayOperation();
    private WeightedMean class;
    private double[] goto = new double[0];
    private final boolean enum;

    private double do() {
        WeightedVariance a2;
        double[] a3 = DoubleArrayMath.add(a2.goto, -a2.class.value());
        double a4 = DoubleArrayMath.sum(void.multiply(a2.catch, DoubleArrayMath.pow(a3, 2.0)));
        double a5 = a2.class.sumOfWeights();
        if (a2.enum) {
            double a6 = DoubleArrayMath.sum2(a2.catch);
            double a7 = a5 * a4 / (a5 * a5 - a6);
            return a7;
        }
        double a8 = a4 / a5;
        return a8;
    }

    @Override
    public long N() {
        return this.goto.length;
    }

    public void addData(double[] data, double[] weights) {
        this.do(data, weights);
    }

    public WeightedVariance(double[] data, double[] weights, boolean unbiased) {
        this.catch = new double[0];
        this.class = new WeightedMean();
        this.enum = unbiased;
        this.do(data, weights);
    }

    @Override
    public void addData(double ... data) {
        ArgumentAssertion.assertTrue(data.length % 2 == 0, "there must be the same number of data points", new Object[0]);
        int a2 = data.length / 2;
        double[] a3 = Arrays.copyOfRange(data, 0, a2);
        double[] a4 = Arrays.copyOfRange(data, a2, data.length);
        this.addData(a3, a4);
    }

    public WeightedVariance(boolean unbiased) {
        this(new double[0], new double[0], unbiased);
    }

    private void do(double[] a2, double[] a3) {
        WeightedVariance a4;
        ArgumentAssertion.assertEqual(a2.length, a3.length, "number of data", "number of weights");
        if (a2.length == 0) {
            return;
        }
        a4.goto = DoubleUtils.concat(a4.goto, a2);
        a4.catch = DoubleUtils.concat(a4.catch, a3);
        a4.class.addData(a2, a3);
        a4.const = a4.do();
    }

    public double stdev() {
        return Math.sqrt(this.const);
    }

    public WeightedVariance() {
        this(true);
    }

    public WeightedVariance(double[] data, double[] weights) {
        this(data, weights, true);
    }

    @Override
    public double value() {
        return this.const;
    }
}

