/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.covariance.nlshrink.quest;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.complex.Complex;
import dev.nm.stat.covariance.nlshrink.quest.Step1FindSupport;
import dev.nm.stat.covariance.nlshrink.quest.Step2ChooseGrid;
import dev.nm.stat.covariance.nlshrink.quest.Step3SolveMPEquation;
import dev.nm.stat.covariance.nlshrink.quest.Step4GetSpectralDensity;
import dev.nm.stat.covariance.nlshrink.quest.Step5GetSampleEigenvaluesCDF;
import dev.nm.stat.covariance.nlshrink.quest.Step6GetSampleEigenvalues;
import java.util.Arrays;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QuEST {
    private final double const;
    private static final double void = 1.0E-8;
    private static final double class = 1.0E-12;
    private final Parameter goto;
    private final double enum;

    public QuEST(Vector tau, int n, double tol, double left_tol) {
        this.const = tol;
        this.enum = left_tol;
        Vector a2 = this.do(tau);
        this.goto = new Parameter(n, a2);
    }

    private Vector do(Vector a2) {
        double[] a3 = a2.toArray();
        Arrays.sort(a3);
        DenseVector a4 = new DenseVector(a3);
        for (int a5 = 1; a5 <= a4.size(); ++a5) {
            QuEST a6;
            if (a4.get(a5) < a6.const && a4.get(a5) > 0.0 || a4.get(a5) > -a6.enum && a4.get(a5) < 0.0) {
                a4.set(a5, 0.0);
            }
            ArgumentAssertion.assertFalse(a4.get(a5) < -a6.enum, "eigenvalue must be +ve", new Object[0]);
        }
        ArgumentAssertion.assertFalse(((Object)a4).equals(a4.ZERO()), "eigenvalues cannot be all zero", new Object[0]);
        return a4;
    }

    public Result evaluate() {
        Step1FindSupport.Result a2 = new Step1FindSupport(this.goto).sup_fn();
        Step2ChooseGrid.Result a3 = new Step2ChooseGrid(this.goto, a2).grid_fn();
        Step3SolveMPEquation.Result a4 = new Step3SolveMPEquation(this.goto, a3).sol_fn();
        Step4GetSpectralDensity.Result a5 = new Step4GetSpectralDensity(this.goto, a4).den_fn();
        Step5GetSampleEigenvaluesCDF.Result a6 = new Step5GetSampleEigenvaluesCDF(this.goto, a2, a5).dis_fn();
        Step6GetSampleEigenvalues.Result a7 = new Step6GetSampleEigenvalues(this.goto, a2, a6).lambda_fn();
        return new Result(this.goto, a2, a6, a7);
    }

    public QuEST(Vector tau, int n) {
        this(tau, n, 1.0E-12, 1.0E-8);
    }

    static class Parameter {
        double c;
        final Vector tau;
        final int p;
        final int n;

        private Parameter(int a2, Vector a3) {
            Parameter a4;
            a4.n = a2;
            a4.p = a3.size();
            a4.c = (double)a4.p / (double)a2;
            a4.tau = a3;
        }
    }

    public static class Result {
        public final Vector pw;
        public final Vector estimated_lambda;
        public final List<Double>[] F;
        public final List<Integer> nidx;
        public final List<Complex>[] dis_m_LF_list;
        public final int numint;
        public final Vector t;
        public final List<Double>[] quant;
        public final Matrix lambda_Jacobian;
        public final int K;
        public final double n;
        public final double c;
        public final List<Integer> nquant;
        public final double pzw;
        public final List<Integer>[] F_idx;
        public final Vector tau;
        public final List<Double>[] x_F;
        public final List<Integer>[] bins;
        public final double p;

        private Result(Parameter a2, Step1FindSupport.Result a3, Step5GetSampleEigenvaluesCDF.Result a4, Step6GetSampleEigenvalues.Result a5) {
            Result a6;
            a6.n = a2.n;
            a6.p = a2.p;
            a6.c = a2.c;
            a6.pzw = a3.pzw;
            a6.tau = a2.tau;
            a6.t = a3.t;
            a6.pw = a3.pw;
            a6.K = a3.K;
            a6.numint = a3.numint;
            a6.dis_m_LF_list = a4.dis_m_LF_list;
            a6.nidx = a5.nidx;
            a6.F_idx = a5.F_idx;
            a6.F = a5.F;
            a6.x_F = a5.x_F;
            a6.nquant = a5.nquant;
            a6.quant = a5.quant;
            a6.bins = a5.bins;
            a6.estimated_lambda = new ImmutableVector(a5.lambda);
            a6.lambda_Jacobian = new ImmutableMatrix(a5.lambda_J);
        }
    }
}

