/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.number.complex;

import dev.nm.algebra.structure.Field;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.NumberUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Complex
extends Number
implements Field<Complex>,
NumberUtils.Comparable<Complex> {
    private static final long serialVersionUID = 1L;
    private final double goto;
    public static final Complex NEGATIVE_INFINITY;
    public static final Complex I;
    public static final Complex POSITIVE_INFINITY;
    public static final Complex ZERO;
    public static final Complex ONE;
    private final double enum;
    public static final Complex NaN;

    public static Complex fromPolar(double r, double theta) {
        return new Complex(r * Math.cos(theta), r * Math.sin(theta));
    }

    public static boolean isNaN(Complex z) {
        return Double.isNaN(z.goto) || Double.isNaN(z.enum);
    }

    @Override
    public Complex divide(Complex that) {
        Complex a2;
        if (Complex.isNaN(this) || Complex.isNaN(that)) {
            return NaN;
        }
        if (Complex.isInfinite(that) && !Complex.isInfinite(this)) {
            return that.ZERO();
        }
        double a3 = this.goto;
        double a4 = this.enum;
        double a5 = that.goto;
        double a6 = that.enum;
        if (Math.abs(a5) < Math.abs(a6)) {
            if (DoubleUtils.isZero(a6, 0.0)) {
                throw new ArithmeticException("division by zero");
            }
            double a7 = a5 / a6;
            double a8 = a5 * a7 + a6;
            a2 = new Complex((a3 * a7 + a4) / a8, (a4 * a7 - a3) / a8);
        } else {
            if (DoubleUtils.isZero(a5, 0.0)) {
                throw new ArithmeticException("division by zero");
            }
            double a9 = a6 / a5;
            double a10 = a6 * a9 + a5;
            a2 = new Complex((a4 * a9 + a3) / a10, (a4 - a3 * a9) / a10);
        }
        return a2;
    }

    @Override
    @Deprecated
    public int intValue() {
        throw new UnsupportedOperationException("Complex number cannot be converted to int.");
    }

    @Override
    public Complex opposite() {
        return new Complex(-this.goto, -this.enum);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Complex a2 = (Complex)obj;
        if (Complex.isNaN(a2)) {
            return Complex.isNaN(this);
        }
        if (DoubleUtils.compare(this.goto, a2.goto, 0.0) != 0) {
            return false;
        }
        return DoubleUtils.compare(this.enum, a2.enum, 0.0) == 0;
    }

    public Complex(double a2) {
        this(a2, 0.0);
    }

    @Override
    public int compare(Number that, double epsilon) {
        Complex a2 = that instanceof Complex ? (Complex)that : new Complex(that.doubleValue(), 0.0);
        int a3 = DoubleUtils.compare(this.goto, a2.goto, epsilon);
        if (a3 != 0) {
            return a3;
        }
        return DoubleUtils.compare(this.enum, a2.enum, epsilon);
    }

    @Override
    public Complex multiply(Complex that) {
        double a2 = this.goto * that.goto;
        double a3 = this.enum * that.enum;
        return new Complex(a2 - a3, (this.goto + this.enum) * (that.goto + that.enum) - a2 - a3);
    }

    @Override
    public Complex inverse() throws Field.InverseNonExistent {
        if (DoubleUtils.isZero(this.goto, 0.0) && DoubleUtils.isZero(this.enum, 0.0)) {
            throw new Field.InverseNonExistent();
        }
        double a2 = this.modulus();
        return new Complex(this.goto / a2, -this.enum / a2);
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 53 * a2 + (int)(Double.doubleToLongBits(this.goto) ^ Double.doubleToLongBits(this.goto) >>> 32);
        a2 = 53 * a2 + (int)(Double.doubleToLongBits(this.enum) ^ Double.doubleToLongBits(this.enum) >>> 32);
        return a2;
    }

    public Double toDouble() {
        if (!Complex.isReal(this)) {
            throw new IllegalArgumentException(String.format("this complex number %s is not real", this.toString()));
        }
        return new Double(this.goto);
    }

    public Complex conjugate() {
        return new Complex(this.goto, -this.enum);
    }

    @Override
    public Complex minus(Complex that) {
        return new Complex(this.goto - that.goto, this.enum - that.enum);
    }

    public double arg() {
        return Math.atan2(this.enum, this.goto);
    }

    public double real() {
        return this.goto;
    }

    @Override
    public Complex add(Complex that) {
        return new Complex(this.goto + that.goto, this.enum + that.enum);
    }

    public static boolean isReal(Complex z) {
        return DoubleUtils.isZero(z.enum, 0.0);
    }

    public double imaginary() {
        return this.enum;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public double modulus() {
        if (DoubleUtils.isZero(this.enum, 0.0)) {
            return Math.abs(this.goto);
        }
        if (DoubleUtils.isZero(this.goto, 0.0)) {
            return Math.abs(this.enum);
        }
        return Math.hypot(this.goto, this.enum);
    }

    static {
        Package.validate("NMDEV_BASIC");
        I = new Complex(0.0, 1.0);
        ZERO = new Complex(0.0, 0.0);
        ONE = new Complex(1.0, 0.0);
        POSITIVE_INFINITY = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        NEGATIVE_INFINITY = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        NaN = new Complex(Double.NaN, Double.NaN);
    }

    @Override
    public double doubleValue() {
        if (!Complex.isReal(this)) {
            throw new IllegalArgumentException(String.format("this complex number %s is not real", this.toString()));
        }
        return this.goto;
    }

    @Override
    @Deprecated
    public long longValue() {
        throw new UnsupportedOperationException("Complex number cannot be converted to long.");
    }

    public Complex(double a2, double b2) {
        if (Double.isNaN(a2) || Double.isNaN(b2)) {
            this.goto = Double.NaN;
            this.enum = Double.NaN;
        } else {
            this.goto = a2;
            this.enum = b2;
        }
    }

    @Override
    public Complex ZERO() {
        return ZERO;
    }

    public static boolean isInfinite(Complex z) {
        return !Complex.isNaN(z) && (Double.isInfinite(z.goto) || Double.isInfinite(z.enum));
    }

    public String toString() {
        String a2 = String.format("%f%s%fi", this.goto, this.enum >= 0.0 ? "+" : "", this.enum);
        return a2;
    }

    @Override
    public Complex ONE() {
        return ONE;
    }
}

