/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.misc.datastructure.time;

import dev.nm.misc.datastructure.time.LocalDateTimeInterval;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LocalDateTimeUtils {
    public static List<LocalDateTime> periodicInstants(LocalDateTime startTime, Period period, int nPeriods) {
        List<LocalDateTime> a2 = Stream.iterate(startTime, a3 -> a3.plus(period)).limit(nPeriods + 1).collect(Collectors.toList());
        return a2;
    }

    public static int comparePeriods(Period period1, Period period2) {
        return LocalDateTimeUtils.comparePeriods(period1, period2, 30);
    }

    public static long periodCountBetween(LocalDateTime t1, LocalDateTime t2, Period period) {
        int a2 = 0;
        LocalDateTime a3 = t1;
        while (a3.isBefore(t2)) {
            ++a2;
            a3.plus(period);
        }
        return a2 - 1;
    }

    public static LocalDateTime min(LocalDateTime t1, LocalDateTime t2) {
        return t2.isBefore(t1) ? t2 : t1;
    }

    public static boolean isWeekend(LocalDateTime time) {
        return time.getDayOfWeek() == DayOfWeek.SATURDAY || time.getDayOfWeek() == DayOfWeek.SUNDAY;
    }

    public static List<LocalDateTime> periodicInstantsWithinInterval(LocalDateTimeInterval interval, Period period) {
        ArrayList<LocalDateTime> a2 = new ArrayList<LocalDateTime>();
        LocalDateTime a3 = interval.start();
        while (a3.isBefore(interval.end())) {
            a2.add(a3);
            a3 = a3.plus(period);
        }
        return a2;
    }

    public static List<LocalDateTime> periodicInstantsSpanningInterval(LocalDateTimeInterval interval, Period period) {
        ArrayList<LocalDateTime> a2 = new ArrayList<LocalDateTime>();
        LocalDateTime a3 = interval.end().plus(period);
        LocalDateTime a4 = interval.start();
        while (a4.isBefore(a3)) {
            a2.add(a4);
            a4 = a4.plus(period);
        }
        return a2;
    }

    public static long periodDayCount(Period period, int nDaysPerMonth) {
        return period.toTotalMonths() * (long)nDaysPerMonth + (long)period.getDays();
    }

    public static int comparePeriods(Period period1, Period period2, int nDaysPerMonth) {
        return Long.compare(LocalDateTimeUtils.periodDayCount(period1, nDaysPerMonth), LocalDateTimeUtils.periodDayCount(period2, nDaysPerMonth));
    }

    public static LocalDateTime previousWeekDay(LocalDateTime time) {
        switch (time.getDayOfWeek()) {
            case MONDAY: {
                return time.minusDays(3L);
            }
            case SUNDAY: {
                return time.minusDays(2L);
            }
        }
        return time.minusDays(1L);
    }

    public static LocalDateTime max(LocalDateTime t1, LocalDateTime t2) {
        return t2.isAfter(t1) ? t2 : t1;
    }

    public static List<LocalDateTimeInterval> fixedSizeIntervals(LocalDateTime start, LocalDateTime end, Period period) {
        ArrayList<LocalDateTimeInterval> a2 = new ArrayList<LocalDateTimeInterval>();
        LocalDateTime a3 = start;
        while (a3.isBefore(end)) {
            a2.add(LocalDateTimeInterval.of(a3, LocalDateTimeUtils.min(a3.plus(period), end)));
            a3 = a3.plus(period);
        }
        return a2;
    }

    public static LocalDateTime nextWeekDay(LocalDateTime time) {
        switch (time.getDayOfWeek()) {
            case FRIDAY: {
                return time.plusDays(3L);
            }
            case SATURDAY: {
                return time.plusDays(2L);
            }
        }
        return time.plusDays(1L);
    }
}

