/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.polynomial.root.jenkinstraub;

import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.analysis.function.polynomial.QuadraticMonomial;
import dev.nm.analysis.function.polynomial.QuadraticSyntheticDivision;
import dev.nm.misc.Constants;

class JTUtils {
    static double[] getUVEstimation(Polynomial a2, Polynomial a3, VarSet a4, QuadraticMonomial a5) {
        double a6 = a5.u();
        double a7 = a5.v();
        double a8 = 0.0;
        double a9 = 0.0;
        switch (a4.type) {
            case UNSCALED: {
                return new double[]{0.0, 0.0};
            }
            case DIVIDED_BY_C: {
                a8 = a4.a + a6 * a4.b + a4.h * a4.f;
                a9 = a4.c + (a6 + a7 * a4.f) * a4.d;
                break;
            }
            case DIVIDED_BY_D: {
                a8 = (a4.a + a4.g) * a4.f + a4.h;
                a9 = (a4.f + a6) * a4.c + a7 * a4.d;
            }
        }
        double a10 = -a3.getCoefficient(a3.degree()) / a2.getCoefficient(a2.degree());
        double a11 = -(a3.getCoefficient(a3.degree() - 1) + a10 * a2.getCoefficient(a2.degree() - 1)) / a2.getCoefficient(a2.degree());
        double a12 = a7 * a11 * a4.a1;
        double a13 = a10 * a4.a7;
        double a14 = a10 * a10 * a4.a3;
        double a15 = -(a13 + a14) + a12;
        double a16 = -a15 + a9 + a10 * a8;
        if (a16 != 0.0) {
            return new double[]{-((a6 * (a14 + a13) + a7 * (a10 * a4.a1 + a11 * a4.a7)) / a16) + a6, a7 * (1.0 + a15 / a16)};
        }
        return new double[]{0.0, 0.0};
    }

    static VarSet getScalarsForNextK(Polynomial a2, double a3, double a4, QuadraticMonomial a5) {
        double a6 = a5.u();
        double a7 = a5.v();
        double a8 = 0.0;
        double a9 = 0.0;
        double a10 = 0.0;
        double a11 = 0.0;
        double a12 = 0.0;
        double a13 = 0.0;
        double a14 = 0.0;
        double a15 = 0.0;
        double a16 = 0.0;
        QuadraticSyntheticDivision a17 = new QuadraticSyntheticDivision(a2, a5);
        Polynomial a18 = a17.quotient();
        a12 = a17.b();
        a11 = a17.a();
        if (Math.abs(a11) <= 100.0 * Constants.MACH_EPS * Math.abs(a2.getCoefficient(a2.degree() - 1)) && Math.abs(a12) <= 100.0 * Constants.MACH_EPS * Math.abs(a2.getCoefficient(a2.degree() - 2))) {
            return new VarSet(VarSet.Type.UNSCALED, a8, a9, a10, a4, a3, a11, a12, a13, a14, a15, a16, a18);
        }
        a16 = a7 * a3;
        if (Math.abs(a12) >= Math.abs(a11)) {
            a13 = a4 / a12;
            a14 = a11 / a12;
            a15 = a6 * a3;
            a9 = a13 * (a15 + a4) + a16 * (a3 / a12);
            a10 = a16 + (a14 + a6) * a4;
            a8 = -a4 + a14 * a3;
            return new VarSet(VarSet.Type.DIVIDED_BY_D, a8, a9, a10, a4, a3, a11, a12, a13, a14, a15, a16, a18);
        }
        a13 = a4 / a11;
        a14 = a12 / a11;
        a15 = a13 * a6;
        a9 = a13 * a4 + (a15 + a16 / a11) * a3;
        a10 = a15 * a12 + a16 * a14 + a4;
        a8 = -(a4 * (a12 / a11)) + a3;
        return new VarSet(VarSet.Type.DIVIDED_BY_C, a8, a9, a10, a4, a3, a11, a12, a13, a14, a15, a16, a18);
    }

    static Polynomial getNextK(Polynomial a2, Polynomial a3, VarSet a4) {
        double a5;
        if (a4.type == VarSet.Type.UNSCALED) {
            return a4.qkPoly;
        }
        double d2 = a5 = a4.type == VarSet.Type.DIVIDED_BY_C ? a4.b : a4.a;
        if (Math.abs(a4.a1) > 10.0 * Constants.MACH_EPS * Math.abs(a5)) {
            double a6 = a4.a7 / a4.a1;
            double a7 = a4.a3 / a4.a1;
            return a4.qkPoly.scaled(a7).add(a3.scaled(-a6)).add(a3.multiply(new Polynomial(1.0, 0.0))).add(new Polynomial(a4.b));
        }
        return a4.qkPoly.scaled(a4.a3).add(a3.scaled(-a4.a7));
    }

    private JTUtils() {
        JTUtils a2;
    }

    static class VarSet {
        final double g;
        final double a3;
        final double h;
        final Type type;
        final double a7;
        final Polynomial qkPoly;
        final double f;
        final double e;
        final double a1;
        final double d;
        final double a;
        final double c;
        final double b;

        VarSet(Type a2, double a3, double a4, double a5, double a6, double a7, double a8, double a9, double a10, double a11, double a12, double a13, Polynomial a14) {
            VarSet a15;
            a15.type = a2;
            a15.a1 = a3;
            a15.a3 = a4;
            a15.a7 = a5;
            a15.a = a6;
            a15.b = a7;
            a15.c = a8;
            a15.d = a9;
            a15.e = a10;
            a15.f = a11;
            a15.g = a12;
            a15.h = a13;
            a15.qkPoly = a14;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        static enum Type {
            DIVIDED_BY_C,
            DIVIDED_BY_D,
            UNSCALED;


            private Type() {
                Type a2;
            }
        }
    }
}

