/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.polynomial;

import dev.nm.algebra.structure.Ring;
import dev.nm.algebra.structure.VectorSpace;
import dev.nm.analysis.function.polynomial.HornerScheme;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.number.DoubleUtils;
import dev.nm.number.Real;
import dev.nm.number.complex.Complex;
import dev.nm.number.complex.ElementaryFunction;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Polynomial
extends AbstractUnivariateRealFunction
implements Ring<Polynomial>,
VectorSpace<Polynomial, Real> {
    private int goto;
    private final double[] enum;
    public static final Polynomial ONE;
    public static final Polynomial ZERO;

    @Override
    public Polynomial minus(Polynomial that) {
        return this.add(that.opposite());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Polynomial)) {
            return false;
        }
        Polynomial a2 = (Polynomial)obj;
        if (this.goto != a2.goto) {
            return false;
        }
        return this.enum == a2.enum || this.enum != null && DoubleUtils.equal(this.enum, a2.enum, 0.0);
    }

    @Override
    public Polynomial ZERO() {
        return ZERO;
    }

    @Override
    public Polynomial multiply(Polynomial that) {
        int a2 = this.goto + that.goto;
        double[] a3 = new double[a2 + 1];
        for (int a4 = 0; a4 < a3.length; ++a4) {
            a3[a4] = 0.0;
            for (int a5 = 0; a5 <= a4; ++a5) {
                int n = a4;
                a3[n] = a3[n] + that.getCoefficient(a5) * this.getCoefficient(a4 - a5);
            }
        }
        return new Polynomial(a3);
    }

    @Override
    public Complex evaluate(Complex z) {
        Object a2 = z.ZERO();
        for (int a3 = 0; a3 <= this.goto; ++a3) {
            a2 = ((Complex)a2).add(ElementaryFunction.pow(z, new Complex(this.goto - a3, 0.0)).multiply(new Complex(this.enum[a3], 0.0)));
        }
        return a2;
    }

    public Polynomial(Polynomial that) {
        this(that.getCoefficients());
    }

    @Override
    public double evaluate(double x) {
        if (this.goto == 0) {
            return this.enum[0];
        }
        HornerScheme a2 = new HornerScheme(this, x);
        return a2.remainder();
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 71 * a2 + this.goto;
        a2 = 71 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
        return a2;
    }

    @Override
    public Polynomial scaled(Real c2) {
        return this.scaled(c2.doubleValue());
    }

    @Override
    public Polynomial opposite() {
        double[] a2 = new double[this.enum.length];
        for (int a3 = 0; a3 <= this.goto; ++a3) {
            a2[a3] = -this.enum[a3];
        }
        return new Polynomial(a2);
    }

    public Polynomial getNormalization() {
        double[] a2 = Arrays.copyOf(this.enum, this.enum.length);
        double a3 = a2[0];
        int a4 = 1;
        while (a4 < a2.length) {
            int n = a4++;
            a2[n] = a2[n] / a3;
        }
        a2[0] = 1.0;
        return new Polynomial(a2);
    }

    static {
        ZERO = new Polynomial(0.0);
        ONE = new Polynomial(1.0);
    }

    @Override
    public Polynomial add(Polynomial that) {
        double[] a2;
        double[] a3;
        if (this.goto > that.goto) {
            a3 = this.enum;
            a2 = that.enum;
        } else {
            a3 = that.enum;
            a2 = this.enum;
        }
        int a4 = a3.length - a2.length;
        double[] a5 = new double[a3.length];
        System.arraycopy(a3, 0, a5, 0, a4);
        for (int a6 = 0; a6 < a2.length; ++a6) {
            a5[a4 + a6] = a3[a4 + a6] + a2[a6];
        }
        return new Polynomial(a5);
    }

    public Polynomial pow(int n) {
        Polynomial a2 = new Polynomial(this);
        for (int a3 = 2; a3 <= n; ++a3) {
            a2 = a2.multiply(this);
        }
        return a2;
    }

    @Override
    public Complex evaluate(Number x) {
        if (x instanceof Complex) {
            return this.evaluate((Complex)x);
        }
        double a2 = this.evaluate(x.doubleValue());
        return new Complex(a2, 0.0);
    }

    public double getCoefficient(int i2) {
        if (i2 < 0) {
            throw new IllegalArgumentException("coefficient index counts from 0, the highest order term");
        }
        return i2 < this.enum.length ? this.enum[i2] : 0.0;
    }

    public Polynomial(double ... coefficients) {
        this.goto = coefficients.length - 1;
        for (int a2 = 0; a2 < coefficients.length - 1 && coefficients[a2] == 0.0; ++a2) {
            --this.goto;
        }
        this.enum = Arrays.copyOfRange(coefficients, coefficients.length - this.goto - 1, coefficients.length);
    }

    @Override
    public Polynomial ONE() {
        return ONE;
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        for (int a3 = 0; a3 <= this.goto; ++a3) {
            if (this.enum[a3] == 0.0) continue;
            if (a3 > 0 && this.enum[a3] >= 0.0) {
                a2.append("+");
            }
            a2.append(String.format("%.2f", this.enum[a3]));
            if (a3 == this.goto) continue;
            a2.append(String.format("(x^%d)", this.goto - a3));
        }
        return a2.toString();
    }

    public int degree() {
        return this.goto;
    }

    @Override
    public Polynomial scaled(double c2) {
        double[] a2 = new double[this.enum.length];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = c2 * this.enum[a3];
        }
        return new Polynomial(a2);
    }

    public double[] getCoefficients() {
        return Arrays.copyOf(this.enum, this.enum.length);
    }
}

