/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;

public class FunctionOps {
    private FunctionOps() {
        FunctionOps a2;
    }

    public static long modpow(long base, long exponent, long modulus) {
        ArgumentAssertion.assertTrue(base > 0L && exponent > 0L && modulus > 0L, "all three numbers must be positive integers", new Object[0]);
        long a2 = 1L;
        while (exponent > 0L) {
            long a3 = base % modulus;
            if ((exponent & 1L) == 1L) {
                a2 = a2 % modulus * a3 % modulus;
            }
            exponent >>= 1;
            base = a3 * a3 % modulus;
        }
        return a2;
    }

    public static double combination(int n, int k2) {
        ArgumentAssertion.assertTrue(n >= k2, "n >= k", new Object[0]);
        ArgumentAssertion.assertTrue(k2 >= 0, "n, k must be 0s or natural numbers", new Object[0]);
        if (n == 0 || k2 == 0 || k2 == n) {
            return 1.0;
        }
        if ((double)k2 > (double)n / 2.0) {
            return FunctionOps.combination(n, n - k2);
        }
        double a2 = 1.0;
        int a3 = n;
        for (int a4 = k2; a3 > n - k2 || a4 > 1; --a3, --a4) {
            if (a3 > n - k2 && a4 > 1) {
                a2 *= (double)a3 / (double)a4;
                continue;
            }
            if (a3 > n - k2) {
                a2 *= (double)a3;
                continue;
            }
            if (a4 > 1) {
                a2 /= (double)a4;
                continue;
            }
            assert (false) : "unreachable";
        }
        return a2;
    }

    public static long dotProduct(long[] x1, long[] x2) {
        ArgumentAssertion.assertEqual(x1.length, x2.length, "x1's length", "x2's length");
        long a2 = 0L;
        for (int a3 = 0; a3 < x1.length; ++a3) {
            a2 += x1[a3] * x2[a3];
        }
        return a2;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public static double linearInterpolate(double x, double x0, double y0, double x1, double y1) {
        double a2 = y0 + (x - x0) * (y1 - y0) / (x1 - x0);
        return a2;
    }

    public static double factorial(int n) {
        ArgumentAssertion.assertNonNegative(n, "n");
        double a2 = 1.0;
        for (int a3 = 2; a3 <= n; ++a3) {
            a2 *= (double)a3;
        }
        return a2;
    }

    public static double dotProduct(double[] x1, double[] x2) {
        ArgumentAssertion.assertEqual(x1.length, x2.length, "x1's length", "x2's length");
        double a2 = 0.0;
        for (int a3 = 0; a3 < x1.length; ++a3) {
            a2 += x1[a3] * x2[a3];
        }
        return a2;
    }

    public static int lcm(int a2, int b2) {
        int a3 = a2;
        int a4 = b2;
        int a5 = FunctionOps.gcd(a3, a4);
        return a3 * (a4 / a5);
    }

    public static int gcd(int a2, int b2) {
        int a3 = a2;
        int a4 = b2;
        while (a4 > 0) {
            int a5 = a4;
            a4 = a3 % a4;
            a3 = a5;
        }
        return a3;
    }

    public static double permutation(int n, int k2) {
        ArgumentAssertion.assertTrue(n >= k2, "n >= k", new Object[0]);
        ArgumentAssertion.assertTrue(k2 >= 0, "n, k must be 0s or natural numbers", new Object[0]);
        if (n == 0 || k2 == 0 || k2 == n) {
            return 1.0;
        }
        double a2 = 1.0;
        int a3 = n;
        for (int a4 = n - k2; a3 > 1 || a4 > 1; --a3, --a4) {
            if (a3 > 1 && a4 > 1) {
                a2 *= (double)a3 / (double)a4;
                continue;
            }
            if (a3 > 1) {
                a2 *= (double)a3;
                continue;
            }
            throw new RuntimeException("unreachable");
        }
        return a2;
    }

    public static long mod(long x, long m2) {
        long a2;
        ArgumentAssertion.assertPositive(m2, "modulus");
        for (a2 = x; a2 < 0L; a2 += m2) {
        }
        if (a2 > m2) {
            a2 %= m2;
        }
        return a2;
    }
}

