/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim2;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.Chol;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.BackwardSubstitution;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.ForwardSubstitution;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentialequation.pde.PDESolver;
import dev.nm.analysis.differentialequation.pde.finitedifference.PDESolutionTimeSpaceGrid2D;
import dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim2.HeatEquation2D;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.number.DoubleUtils;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlternatingDirectionImplicitMethod
implements PDESolver {
    private final boolean class;
    private final double goto;
    private static final ParallelExecutor enum;

    private static Vector short(double[][][] a2, double a3, double a4, int a5, int a6, int a7) {
        int a8 = a6 + 1;
        DenseVector a9 = new DenseVector(a5);
        double a10 = 1.0 - 2.0 * a4;
        for (int a11 = 1; a11 <= a5; ++a11) {
            a9.set(a11, a4 * (a2[a8][a11][a7 - 1] + a2[a8][a11][a7 + 1]) + a10 * a2[a8][a11][a7]);
        }
        a9.set(1, a9.get(1) + a3 * a2[a8 + 1][0][a7]);
        a9.set(a5, a9.get(a5) + a3 * a2[a8 + 1][a5 + 1][a7]);
        return a9;
    }

    public AlternatingDirectionImplicitMethod(double epsilon, boolean parallel) {
        this.goto = epsilon;
        this.class = parallel;
    }

    private static Vector do(double[][][] a2, double a3, double a4, int a5, int a6, int a7) {
        DenseVector a8 = new DenseVector(a5);
        double a9 = 1.0 - 2.0 * a3;
        for (int a10 = 1; a10 <= a5; ++a10) {
            a8.set(a10, a3 * (a2[a6][a7 - 1][a10] + a2[a6][a7 + 1][a10]) + a9 * a2[a6][a7][a10]);
        }
        a8.set(1, a8.get(1) + a4 * a2[a6 + 1][a7][0]);
        a8.set(a5, a8.get(a5) + a4 * a2[a6 + 1][a7][a5 + 1]);
        return a8;
    }

    public PDESolutionTimeSpaceGrid2D solve(HeatEquation2D pde, final int m2, final int n, final int p) {
        int a2;
        ArgumentAssertion.assertPositive(m2, "the number of time-axis grid points");
        ArgumentAssertion.assertPositive(n, "the number of x-axis grid points");
        ArgumentAssertion.assertPositive(p, "the number of y-axis grid points");
        final double[] a3 = DoubleUtils.seq(0.0, pde.T(), 2 * m2 + 1);
        final double[] a4 = DoubleUtils.seq(0.0, pde.a(), n + 2);
        final double[] a5 = DoubleUtils.seq(0.0, pde.b(), p + 2);
        double a6 = a3[1];
        double a7 = a4[1];
        double a8 = a5[1];
        final double[][][] a9 = new double[2 * m2 + 1][n + 2][p + 2];
        for (a2 = 0; a2 < a9.length; ++a2) {
            int a10;
            for (int a11 : new int[]{0, n + 1}) {
                for (a10 = 0; a10 < p + 2; ++a10) {
                    a9[a2][a11][a10] = pde.g(a3[a2], a4[a11], a5[a10]);
                }
            }
            for (int a11 : new int[]{0, p + 1}) {
                for (a10 = 1; a10 < n + 1; ++a10) {
                    a9[a2][a10][a11] = pde.g(a3[a2], a4[a10], a5[a11]);
                }
            }
        }
        for (a2 = 1; a2 <= n; ++a2) {
            for (int a12 = 1; a12 <= p; ++a12) {
                a9[0][a2][a12] = pde.f(a4[a2], a5[a12]);
            }
        }
        double a13 = pde.beta();
        final double a14 = a13 * a6 / (a7 * a7);
        final double a15 = a13 * a6 / (a8 * a8);
        Matrix a16 = AlternatingDirectionImplicitMethod.do(a14, n);
        Matrix a17 = AlternatingDirectionImplicitMethod.do(a15, p);
        final ForwardSubstitution a18 = new ForwardSubstitution();
        final BackwardSubstitution a19 = new BackwardSubstitution();
        final Chol a20 = new Chol(a16, this.goto);
        final Chol a21 = new Chol(a17, this.goto);
        int a22 = 0;
        while (a22 + 2 < a9.length) {
            final int a23 = a22;
            try {
                enum.conditionalForLoop(this.class, 1, n + 1, new LoopBody(){
                    {
                        1 a3;
                    }

                    @Override
                    public void run(int i2) throws Exception {
                        Vector a2 = AlternatingDirectionImplicitMethod.do(a9, a14, a15, p, a23, i2);
                        Vector a3 = a19.solve(a21.Lt(), a18.solve(a21.L(), a2));
                        for (int a4 = 1; a4 <= p; ++a4) {
                            a9[a23 + 1][i2][a4] = a3.get(a4);
                        }
                    }
                });
                enum.conditionalForLoop(this.class, 1, p + 1, new LoopBody(){

                    @Override
                    public void run(int j2) throws Exception {
                        Vector a2 = AlternatingDirectionImplicitMethod.short(a9, a14, a15, n, a23, j2);
                        Vector a3 = a19.solve(a20.Lt(), a18.solve(a20.L(), a2));
                        for (int a4 = 1; a4 <= n; ++a4) {
                            a9[a23 + 2][a4][j2] = a3.get(a4);
                        }
                    }
                    {
                        2 a3;
                    }
                });
            }
            catch (MultipleExecutionException a24) {
                throw new RuntimeException(a24);
            }
            a22 += 2;
        }
        return new PDESolutionTimeSpaceGrid2D(){

            @Override
            public double x(int i2) {
                ArgumentAssertion.assertRange(i2, 0, n + 1, "i");
                return a4[i2];
            }
            {
                3 a32;
            }

            @Override
            public int n() {
                return n;
            }

            @Override
            public double t(int k2) {
                ArgumentAssertion.assertRange(k2, 0, m2, "k");
                return a3[2 * k2];
            }

            @Override
            public double u(int k2, int i2, int j2) {
                ArgumentAssertion.assertRange(k2, 0, m2, "k");
                ArgumentAssertion.assertRange(i2, 0, n + 1, "i");
                ArgumentAssertion.assertRange(j2, 0, p + 1, "j");
                return a9[2 * k2][i2][j2];
            }

            @Override
            public double y(int j2) {
                ArgumentAssertion.assertRange(j2, 0, p + 1, "j");
                return a5[j2];
            }

            @Override
            public int m() {
                return m2;
            }

            @Override
            public int p() {
                return p;
            }
        };
    }

    private static Matrix do(double a2, int a3) {
        double[] a4 = new double[a3];
        Arrays.fill(a4, 1.0 + 2.0 * a2);
        double[] a5 = new double[a3 - 1];
        Arrays.fill(a5, -a2);
        return new TridiagonalMatrix(new double[][]{a5, a4, a5});
    }

    public AlternatingDirectionImplicitMethod(double epsilon) {
        this(epsilon, true);
    }

    static {
        Package.validate("NMDEV_OPDE");
        enum = new ParallelExecutor(AlternatingDirectionImplicitMethod.class.getSimpleName());
    }
}

