/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentialequation.pde.PDESolver;
import dev.nm.analysis.differentialequation.pde.finitedifference.PDESolutionTimeSpaceGrid1D;
import dev.nm.analysis.differentialequation.pde.finitedifference.PDETimeSpaceGrid1D;
import dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.convectiondiffusionequation.ConvectionDiffusionEquation1D;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;

public class CrankNicolsonConvectionDiffusionEquation1D
implements PDESolver {
    public PDESolutionTimeSpaceGrid1D solve(final ConvectionDiffusionEquation1D pde, final int M2, final int N) {
        ArgumentAssertion.assertGreaterThan(M2, 0, "the number of time-axis grid points");
        ArgumentAssertion.assertGreaterThan(N, 0, "the number of space-axis grid points");
        final double[] a2 = DoubleUtils.seq(0.0, pde.T(), M2 + 1);
        final double[] a3 = DoubleUtils.seq(0.0, pde.a(), N + 2);
        final Coefficients a4 = new Coefficients(pde, M2, N, a3);
        PDETimeSpaceGrid1D a5 = new PDETimeSpaceGrid1D(M2){

            @Override
            public void initialCondition() {
                this.u[0] = new DenseVector(N);
                for (int a22 = 1; a22 <= N; ++a22) {
                    this.u[0].set(a22, pde.f(a3[a22]));
                }
            }

            @Override
            public Vector getRHS(int m2) {
                Vector a22 = a4.getRHS(this.u[m2 - 1], a2[m2 - 1]);
                return a22;
            }
            {
                1 a42;
                super(a32);
            }

            @Override
            public TridiagonalMatrix getLHS(int m2) {
                TridiagonalMatrix a22 = a4.getLHS(a2[m2 - 1]);
                return a22;
            }
        };
        final Vector[] a6 = a5.propagate();
        return new PDESolutionTimeSpaceGrid1D(){

            @Override
            public double t(int m2) {
                ArgumentAssertion.assertRange(m2, 0, M2, "m");
                return a2[m2];
            }

            @Override
            public double x(int n) {
                ArgumentAssertion.assertRange(n, 0, N + 1, "n");
                return a3[n];
            }

            @Override
            public int N() {
                return N;
            }

            @Override
            public int M() {
                return M2;
            }
            {
                2 a32;
            }

            @Override
            public double u(int m2, int n) {
                ArgumentAssertion.assertRange(m2, 0, M2, "m");
                ArgumentAssertion.assertRange(n, 0, N + 1, "n");
                if (n == 0 || n == N + 1) {
                    throw new UnsupportedOperationException("boundary values are not available");
                }
                return a6[m2].get(n);
            }
        };
    }

    static {
        Package.validate("NMDEV_OPDE");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Coefficients {
        private final double new;
        private final double super;
        private final int final;
        private final double break;
        private final double else;
        private final double[] catch;
        private final double const;
        private final double void;
        private final ConvectionDiffusionEquation1D class;
        private final double goto;
        private final double enum;

        public Coefficients(ConvectionDiffusionEquation1D pde, int M2, int N, double[] x) {
            this.class = pde;
            this.final = N;
            this.catch = x;
            this.super = x[1];
            this.void = this.super / 2.0;
            this.break = pde.T() / (double)M2;
            this.const = 0.5 * this.break / (this.super * this.super);
            this.else = pde.c1();
            this.new = pde.c2();
            this.goto = 1.0 / (this.else + (1.0 - this.else) * this.super);
            this.enum = 1.0 / (this.new + (1.0 - this.new) * this.super);
        }

        public TridiagonalMatrix getLHS(double tm) {
            double a2 = tm + 0.5 * this.break;
            double[] a3 = new double[this.final - 1];
            double[] a4 = new double[this.final];
            double[] a5 = new double[this.final - 1];
            double a6 = this.class.sigma(a2, this.catch[1]);
            double a7 = this.class.mu(a2, this.catch[1]);
            a4[0] = 1.0 + 2.0 * this.const * a6 - this.const * this.goto * this.else * (a6 + this.void * a7);
            a3[0] = this.const * (-a6 + this.void * a7);
            for (int a8 = 1; a8 < this.final - 1; ++a8) {
                double a9 = this.class.sigma(a2, this.catch[a8 + 1]);
                double a10 = this.class.mu(a2, this.catch[a8 + 1]);
                a5[a8 - 1] = -this.const * (a9 + this.void * a10);
                a4[a8] = 1.0 + 2.0 * this.const * a9;
                a3[a8] = this.const * (-a9 + this.void * a10);
            }
            double a11 = this.class.sigma(a2, this.catch[this.final]);
            double a12 = this.class.mu(a2, this.catch[this.final]);
            a4[this.final - 1] = 1.0 + 2.0 * this.const * a11 - this.const * this.enum * this.new * (a11 - this.void * a12);
            a5[this.final - 2] = -this.const * (a11 + this.void * a12);
            TridiagonalMatrix a13 = new TridiagonalMatrix(new double[][]{a3, a4, a5});
            return a13;
        }

        public Vector getRHS(Vector um, double tm) {
            double a2 = tm + 0.5 * this.break;
            double a3 = tm + this.break;
            DenseVector a4 = new DenseVector(this.final);
            double a5 = this.class.sigma(a2, this.catch[1]);
            double a6 = this.class.mu(a2, this.catch[1]);
            double a7 = um.get(2) * this.const * (a5 - this.void * a6) + um.get(1) * (1.0 - 2.0 * this.const * a5 + this.const * this.goto * this.else * (a5 + this.void * a6)) + this.const * (this.class.g1(tm) + this.class.g1(a3)) * this.super * this.goto * (a5 + this.void * a6) + this.class.R(a2, this.catch[1]) * this.break;
            a4.set(1, a7);
            for (int a8 = 2; a8 < this.final; ++a8) {
                double a9 = this.class.sigma(a2, this.catch[a8]);
                double a10 = this.class.mu(a2, this.catch[a8]);
                double a11 = um.get(a8 + 1) * this.const * (a9 - this.void * a10) + um.get(a8) * (1.0 - 2.0 * this.const * a9) + um.get(a8 - 1) * this.const * (a9 + this.void * a10) + this.class.R(a2, this.catch[a8]) * this.break;
                a4.set(a8, a11);
            }
            double a12 = this.class.sigma(a2, this.catch[this.final]);
            double a13 = this.class.mu(a2, this.catch[this.final]);
            double a14 = um.get(this.final) * (1.0 - 2.0 * this.const * a12 + this.const * this.enum * this.new * (a12 - this.void * a13)) + um.get(this.final - 1) * this.const * (a12 + this.void * a13) + this.const * (this.class.g2(tm) + this.class.g2(a3)) * this.super * this.enum * (a12 - this.void * a13) + this.class.R(a2, this.catch[this.final]) * this.break;
            a4.set(this.final, a14);
            return a4;
        }
    }
}

