/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.IdentityPreconditioner;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.PreconditionerFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.algorithm.iterative.monitor.IterationMonitor;
import dev.nm.misc.algorithm.iterative.monitor.NullMonitor;
import dev.nm.misc.algorithm.iterative.tolerance.Tolerance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SteepestDescentSolver
implements IterativeLinearSystemSolver {
    private final Tolerance void;
    private final int class;
    private final PreconditionerFactory goto;
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final int enum;

    public SteepestDescentSolver(int maxIteration, Tolerance tolerance) {
        this(new PreconditionerFactory(){
            {
                1 a2;
            }

            @Override
            public Preconditioner newInstance(Matrix A2) {
                return new IdentityPreconditioner();
            }
        }, 50, maxIteration, tolerance);
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    public SteepestDescentSolver(PreconditionerFactory leftPreconditionerFactory, int residualRefreshRate, int maxIteration, Tolerance tolerance) {
        this.goto = leftPreconditionerFactory;
        this.enum = residualRefreshRate;
        this.class = maxIteration;
        this.void = tolerance;
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        return new IterativeLinearSystemSolver.Solution(){
            private final Vector else;
            private Vector catch;
            private int const;
            private Vector void;
            private boolean class;
            private final Matrix goto;
            private final Preconditioner enum;

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.void);
                Vector a2 = this.enum.solve(this.catch);
                Vector a3 = this.goto.multiply(a2);
                double a4 = this.catch.innerProduct(a2) / a3.innerProduct(a2);
                this.void = this.void.add(a2.scaled(a4));
                this.catch = (this.const + 1) % SteepestDescentSolver.this.enum != 0 ? this.catch.minus(a3.scaled(a4)) : this.else.minus(this.goto.multiply(this.void));
                return monitor;
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.const < SteepestDescentSolver.this.class && !this.class) {
                    this.step();
                    ++this.const;
                    this.class |= SteepestDescentSolver.this.void.isResidualSmall(this.catch.norm());
                }
                monitor.addIterate(this.void);
                if (!this.class) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, SteepestDescentSolver.this.class + " iterations exceeded");
                }
                return this.void;
            }
            {
                2 a3;
                a3.goto = a3.problem.A();
                a3.else = a3.problem.b();
                a3.enum = a3.SteepestDescentSolver.this.goto.newInstance(a3.goto);
                a3.const = 0;
            }

            public void setInitials(Vector ... initials) {
                this.void = initials[0];
                this.catch = this.else.minus(this.goto.multiply(this.void));
                this.class = SteepestDescentSolver.this.void.isResidualSmall(this.catch.norm());
            }
        };
    }
}

