/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseStructure;
import java.util.Comparator;
import java.util.List;

public interface SparseMatrix
extends Matrix,
Densifiable,
SparseStructure {
    public List<Entry> getEntryList();

    public SparseMatrix subMatrix(int var1, int var2, int var3, int var4);

    public ValueArray getValueArray();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ValueArray {
        private final double[] class;
        private final int[] goto;
        private final int[] enum;

        public int[] rowIndices() {
            return this.goto;
        }

        public ValueArray(int[] rowIndices, int[] columnIndices, double[] values) {
            this.goto = rowIndices;
            this.enum = columnIndices;
            this.class = values;
        }

        public double[] values() {
            return this.class;
        }

        public int[] columnIndices() {
            return this.enum;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Entry {
        public final double value;
        public final MatrixCoordinate coordinates;
        public static final Comparator<Entry> ROW_MAJOR_ORDER = (a2, a3) -> {
            int a4 = Integer.compare(a2.coordinates.i, a3.coordinates.i);
            if (a4 != 0) {
                return a4;
            }
            return Integer.compare(a2.coordinates.j, a3.coordinates.j);
        };

        public Entry(MatrixCoordinate coordinates, double value) {
            this.coordinates = coordinates;
            this.value = value;
        }

        public int hashCode() {
            int a2 = 7;
            a2 = 83 * a2 + (this.coordinates != null ? this.coordinates.hashCode() : 0);
            a2 = 83 * a2 + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
            return a2;
        }

        public String toString() {
            return String.format("%s = %f", this.coordinates, this.value);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry a2 = (Entry)obj;
            if (!(this.coordinates == a2.coordinates || this.coordinates != null && this.coordinates.equals(a2.coordinates))) {
                return false;
            }
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(a2.value);
        }
    }
}

