/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseData;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.TriangularDataAccessUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.number.doublearray.DoubleArrayOperation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LowerTriangularMatrix
implements Matrix,
Densifiable {
    private static final MatrixMathOperation class = new AutoParallelMatrixMathOperation();
    private final int goto;
    private final MyDenseData enum;

    @Override
    public int nRows() {
        return this.goto;
    }

    private LowerTriangularMatrix(MyDenseData a2) {
        LowerTriangularMatrix a3;
        a3.enum = a2;
        a3.goto = a2.nRows();
    }

    LowerTriangularMatrix(double[] a2, int a3) {
        a4(new MyDenseData(a2, a3));
        LowerTriangularMatrix a4;
    }

    @Override
    public LowerTriangularMatrix opposite() {
        return this.scaled(-1.0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!LowerTriangularMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        LowerTriangularMatrix a2 = (LowerTriangularMatrix)obj;
        if (this.goto != a2.goto) {
            return false;
        }
        return this.enum == a2.enum || this.enum != null && this.enum.equals(a2.enum);
    }

    @Override
    public DenseMatrix toDense() {
        double[] a2 = this.enum.asArray();
        int a3 = 0;
        double[] a4 = new double[this.nRows() * this.nCols()];
        int a5 = 1;
        int a6 = 0;
        while (a6 < a4.length) {
            for (int a7 = 0; a7 < a5; ++a7) {
                a4[a6 + a7] = a2[a3++];
            }
            a6 += this.nCols();
            ++a5;
        }
        return new DenseMatrix(a4, this.nRows(), this.nCols());
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 17 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
        a2 = 17 * a2 + this.goto;
        return a2;
    }

    @Override
    public LowerTriangularMatrix deepCopy() {
        return new LowerTriangularMatrix(this);
    }

    @Override
    public LowerTriangularMatrix ZERO() {
        LowerTriangularMatrix a2 = new LowerTriangularMatrix(this.goto);
        return a2;
    }

    @Override
    public UpperTriangularMatrix t() {
        double[] a2 = new double[this.enum.asArray().length];
        double[] a3 = this.enum.asArray();
        int a4 = 0;
        for (int a5 = 1; a5 <= this.nCols(); ++a5) {
            int a6 = (a5 + 2) * (a5 - 1) >> 1;
            int a7 = a5 - 1;
            int a8 = 0;
            while (a7 < this.nRows()) {
                a2[a4++] = a3[a6 + a8];
                a8 += ++a7;
            }
        }
        return new UpperTriangularMatrix(a2, this.goto);
    }

    @Override
    public Vector multiply(Vector v) {
        return LowerTriangularMatrix.class.multiply((MatrixAccess)this, v);
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof LowerTriangularMatrix) {
            return new LowerTriangularMatrix((MyDenseData)this.enum.add(((LowerTriangularMatrix)that).enum));
        }
        return LowerTriangularMatrix.class.add(this, that);
    }

    public LowerTriangularMatrix(double[][] data) {
        this(data[data.length - 1].length);
        for (int a2 = 1; a2 <= this.goto; ++a2) {
            if (data[a2 - 1].length == a2) continue;
            throw new IllegalArgumentException("data set is not lower triangular");
        }
        double[] a3 = this.enum.asArray();
        int a4 = 0;
        for (int a5 = 0; a5 < this.goto; ++a5) {
            for (int a6 = 0; a6 <= a5; ++a6) {
                a3[a4++] = data[a5][a6];
            }
        }
    }

    public String toString() {
        return MatrixUtils.toString(this);
    }

    @Override
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        this.enum.set(i2, j2, value);
    }

    @Override
    public Vector getColumn(int j2) {
        if (j2 < 1) {
            throw new IllegalArgumentException("row/col counts from 1");
        }
        if (j2 > this.nCols()) {
            throw new IllegalArgumentException("invalid index");
        }
        double[] a2 = this.enum.asArray();
        double[] a3 = new double[this.nRows()];
        int a4 = (j2 + 2) * (j2 - 1) >> 1;
        int a5 = j2 - 1;
        int a6 = j2;
        while (a5 < a3.length) {
            a3[a5] = a2[a4];
            a4 += a6;
            ++a5;
            ++a6;
        }
        return new DenseVector(a3);
    }

    @Override
    public Matrix multiply(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (!(that instanceof LowerTriangularMatrix)) {
            return LowerTriangularMatrix.class.multiply((MatrixAccess)this, that);
        }
        MyDenseData a2 = this.enum;
        MyDenseData a3 = ((LowerTriangularMatrix)that).enum;
        LowerTriangularMatrix a4 = new LowerTriangularMatrix(this.goto);
        MyDenseData a5 = a4.enum;
        for (int a6 = 1; a6 <= this.goto; ++a6) {
            for (int a7 = 1; a7 <= a6; ++a7) {
                double a8 = 0.0;
                for (int a9 = a7; a9 <= a6; ++a9) {
                    a8 += a2.get(a6, a9) * a3.get(a9, a7);
                }
                a5.set(a6, a7, a8);
            }
        }
        return a4;
    }

    @Override
    public Vector getRow(int i2) {
        if (i2 < 1) {
            throw new IllegalArgumentException("row/col counts from 1");
        }
        if (i2 > this.nRows()) {
            throw new IllegalArgumentException("invalid index");
        }
        double[] a2 = this.enum.asArray();
        double[] a3 = new double[this.nCols()];
        int a4 = i2 * (i2 - 1) >> 1;
        for (int a5 = 0; a5 < i2; ++a5) {
            a3[a5] = a2[a5 + a4];
        }
        return new DenseVector(a3);
    }

    @Override
    public int nCols() {
        return this.goto;
    }

    public LowerTriangularMatrix(LowerTriangularMatrix L2) {
        this((MyDenseData)L2.enum.deepCopy());
    }

    public LowerTriangularMatrix(int dim) {
        this(new MyDenseData(dim));
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof LowerTriangularMatrix) {
            return new LowerTriangularMatrix((MyDenseData)this.enum.minus(((LowerTriangularMatrix)that).enum));
        }
        return LowerTriangularMatrix.class.minus(this, that);
    }

    @Override
    public double get(int i2, int j2) throws MatrixAccessException {
        return this.enum.get(i2, j2);
    }

    @Override
    public LowerTriangularMatrix ONE() {
        LowerTriangularMatrix a2 = new LowerTriangularMatrix(this.goto);
        for (int a3 = 1; a3 <= this.goto; ++a3) {
            a2.set(a3, a3, 1.0);
        }
        return a2;
    }

    @Override
    public LowerTriangularMatrix scaled(double scalar) {
        return new LowerTriangularMatrix((MyDenseData)this.enum.scaled(scalar));
    }

    public LowerTriangularMatrix(Matrix A2) {
        this(A2.nRows());
        if (!DimensionCheck.isSquare(A2)) {
            throw new IllegalArgumentException("a lower triangular matrix must be square");
        }
        for (int a2 = 1; a2 <= this.goto; ++a2) {
            for (int a3 = 1; a3 <= a2; ++a3) {
                this.set(a2, a3, A2.get(a2, a3));
            }
        }
    }

    private static final class MyDenseData
    extends DenseData {
        @Override
        public int position(int nRows, int nCols, int i2, int j2) {
            if (i2 >= j2) {
                int a2 = (i2 * (i2 - 1) >> 1) + j2 - 1;
                return a2;
            }
            return -1;
        }

        private MyDenseData(int a2) {
            a3(new double[TriangularDataAccessUtils.dataLength(a2)], a2);
            MyDenseData a3;
        }

        @Override
        protected MyDenseData newInstance(double[] data, int nRows, int nCols, DoubleArrayOperation operation) {
            return new MyDenseData(data, nRows, operation);
        }

        private MyDenseData(double[] a2, int a3) {
            super(a2, a3, a3);
            MyDenseData a4;
        }

        private MyDenseData(double[] a2, int a3, DoubleArrayOperation a4) {
            super(a2, a3, a3, a4);
            MyDenseData a5;
        }
    }
}

