/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.linearsystem;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.gaussianelimination.GaussJordanElimination;
import dev.nm.algebra.linear.matrix.doubles.factorization.qr.HouseholderQR;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Kernel {
    private final int else;
    private Matrix catch;
    private final int const;
    private final Method void;
    private Matrix class;
    private Map<Integer, Vector> goto;
    private final double enum;

    public Kernel(Matrix A2, Method method, double epsilon) {
        ArgumentAssertion.assertTrue(A2.nCols() >= A2.nRows(), "cannot compute for an over-determined system", new Object[0]);
        this.const = A2.nRows();
        this.else = A2.nCols();
        this.void = method;
        this.enum = epsilon;
        GaussJordanElimination a2 = new GaussJordanElimination(A2, true, epsilon);
        this.class = a2.U();
        this.catch = a2.T();
        switch (this.void) {
            case GAUSSIAN_JORDAN_ELIMINATION: {
                this.goto = this.do();
                break;
            }
            default: {
                this.goto = this.do(A2);
            }
        }
    }

    public Matrix U() {
        return this.class.deepCopy();
    }

    private Map<Integer, Vector> do() {
        Kernel a2;
        HashMap<Integer, Vector> a3 = new HashMap<Integer, Vector>();
        for (int a4 = 1; a4 <= a2.else; ++a4) {
            a3.put(new Integer(a4), null);
        }
        HashMap<Integer, Integer> a5 = new HashMap<Integer, Integer>();
        block1: for (int a6 = 1; a6 <= a2.const; ++a6) {
            for (int a7 = a6; a7 <= a2.else; ++a7) {
                if (a2.class.get(a6, a7) != 1.0) continue;
                a3.remove(new Integer(a7));
                a5.put(new Integer(a7), new Integer(a6));
                continue block1;
            }
        }
        Set a8 = a3.keySet();
        for (Integer a9 : a8) {
            DenseVector a10 = new DenseVector(a2.else);
            a10.set((int)a9, 1.0);
            Set a11 = a5.keySet();
            for (Integer a12 : a11) {
                int a13 = (Integer)a5.get(a12);
                double a14 = a2.class.get(a13, a9);
                a10.set((int)a12, -a14);
            }
            a3.put(a9, a10);
        }
        return a3;
    }

    public int rank() {
        return this.else - this.goto.size();
    }

    public Map<Integer, Vector> basisAndFreeVars() {
        HashMap<Integer, Vector> a2 = new HashMap<Integer, Vector>();
        Set<Integer> a3 = this.goto.keySet();
        for (Integer a4 : a3) {
            Vector a5 = this.goto.get(a4).deepCopy();
            a2.put(a4, a5);
        }
        return a2;
    }

    private Map<Integer, Vector> do(Matrix a2) {
        Kernel a3;
        HashMap<Integer, Vector> a4 = new HashMap<Integer, Vector>();
        Matrix a5 = a2.t();
        HouseholderQR a6 = new HouseholderQR(a5, a3.enum);
        Matrix a7 = a6.squareQ();
        int a8 = a6.rank();
        for (int a9 = a8 + 1; a9 <= a7.nCols(); ++a9) {
            Vector a10 = a7.getColumn(a9);
            a10 = a10.scaled(1.0 / a10.norm());
            a4.put(new Integer(a9 - a8), a10);
        }
        return a4;
    }

    public int nullity() {
        return this.goto.size();
    }

    public Matrix T() {
        return this.catch.deepCopy();
    }

    public boolean isZero() {
        return this.goto.isEmpty();
    }

    public List<Vector> basis() {
        ArrayList<Vector> a2 = new ArrayList<Vector>();
        for (Map.Entry<Integer, Vector> a3 : this.goto.entrySet()) {
            Vector a4 = a3.getValue().deepCopy();
            a2.add(a4);
        }
        return a2;
    }

    public Kernel(Matrix A2) {
        this(A2, Method.QR, PrecisionUtils.autoEpsilon(A2));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Method {
        QR,
        GAUSSIAN_JORDAN_ELIMINATION;


        private Method() {
            Method a2;
        }
    }
}

