/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.svd;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.GolubKahanSVD;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.SVDDecomposition;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.mr3.SVDbyMR3;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SVD
implements SVDDecomposition {
    private final double const;
    private final Matrix void;
    private final boolean class;
    private final SVDDecomposition goto;
    private final boolean enum;
    public static final Method DEFAULT_METHOD = Method.MR3;

    @Override
    public Matrix V() {
        Matrix a2 = this.class ? this.goto.V() : this.goto.U();
        return a2;
    }

    @Override
    public double[] getSingularValues() {
        return this.goto.getSingularValues();
    }

    public SVD(Matrix A2, boolean doUV, double epsilon, Method method) {
        this.void = A2;
        this.enum = doUV;
        this.const = epsilon;
        this.class = DimensionCheck.isTall(A2);
        Matrix a2 = this.class ? this.void : this.void.t();
        this.goto = method.getImplementation(a2, this.enum, this.const);
    }

    public SVD(Matrix A2, boolean doUV) {
        this(A2, doUV, PrecisionUtils.autoEpsilon(A2));
    }

    public SVD(Matrix A2, boolean doUV, double epsilon) {
        this(A2, doUV, epsilon, Method.MR3);
    }

    @Override
    public DiagonalMatrix D() {
        return this.goto.D();
    }

    @Override
    public Matrix Ut() {
        return this.U().t();
    }

    @Override
    public Matrix U() {
        Matrix a2 = this.class ? this.goto.U() : this.goto.V();
        return a2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Method {
        GOLUB_KAHAN{

            @Override
            SVDDecomposition getImplementation(Matrix a2, boolean a3, double a4) {
                return new GolubKahanSVD(a2, a3, true, a4);
            }
            {
                1 a2;
            }
        }
        ,
        MR3{
            {
                2 a2;
            }

            @Override
            SVDDecomposition getImplementation(Matrix a2, boolean a3, double a4) {
                return new SVDbyMR3(a2, a3);
            }
        };


        abstract SVDDecomposition getImplementation(Matrix var1, boolean var2, double var3);

        private Method() {
            Method a2;
        }
    }
}

