/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.svd;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.diagonalization.BiDiagonalizationByHouseholder;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.GolubKahanSVDStep;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.SVD2x2;
import dev.nm.algebra.linear.matrix.doubles.factorization.svd.SVDDecomposition;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.GivensMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.ExceptionUtils;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GolubKahanSVD
implements SVDDecomposition {
    private final int int;
    private static int new;
    private Matrix super;
    private final boolean final;
    private DiagonalMatrix break;
    private Matrix else;
    private static final ParallelExecutor catch;
    private final int const;
    private final double void;
    private Matrix class;
    private final boolean goto;
    private final int enum;

    public GolubKahanSVD(Matrix A2, boolean doUV, boolean normalize, double epsilon, int maxIterations) {
        ArgumentAssertion.assertTrue(DimensionCheck.isTall(A2), "A must be tall", new Object[0]);
        this.goto = doUV;
        this.final = normalize;
        this.void = epsilon;
        this.int = maxIterations;
        this.const = A2.nRows();
        this.enum = A2.nCols();
        this.short(A2);
    }

    private void short(Matrix a2) {
        Object a3;
        Matrix a4;
        GolubKahanSVD a5;
        BiDiagonalizationByHouseholder a6 = new BiDiagonalizationByHouseholder(a2);
        Matrix a7 = a6.U();
        Matrix a8 = a6.V();
        DenseMatrix a9 = a6.B().toDense();
        ArrayList<UVOperation> a10 = new ArrayList<UVOperation>(2 * a5.enum);
        ArrayList<UVOperation> a11 = new ArrayList<UVOperation>(2 * a5.enum);
        int a12 = 0;
        int a13 = 0;
        int a14 = 0;
        for (a14 = 0; a14 < a5.int; ++a14) {
            a5.do(a9);
            for (a12 = a5.enum; a12 > 1 && a5.short(a9, a12 - 1, a5.void); --a12) {
            }
            if (a12 <= 1) break;
            for (a13 = a12 - 1; a13 >= 2 && !a5.short(a9, a13 - 1, a5.void); --a13) {
            }
            int a15 = a12 - a13 + 1;
            a4 = a5.do((Matrix)a9, a13, a12);
            if (DoubleUtils.isZero(a4.get(a15, a15), a5.void)) {
                a3 = a5.do(a4);
                if (a5.goto) {
                    a11.add(a5.new MultiplyGivensMatrices((List)a3, a13));
                }
            } else if (DoubleUtils.hasZero(VectorFactory.diagonal(a4).toArray(), a5.void)) {
                a3 = a5.short(a4);
                if (a5.goto) {
                    a10.add(a5.new MultiplyGivensMatrices((List)a3, a13));
                }
            } else if (a15 == 2) {
                a3 = new SVD2x2(a4);
                a4 = ((SVD2x2)a3).D();
                if (a5.goto) {
                    a10.add(a5.new Multiply2x2Block(((SVD2x2)a3).U(), a13));
                    a11.add(a5.new Multiply2x2Block(((SVD2x2)a3).V(), a13));
                }
            } else {
                a3 = new BidiagonalMatrix(new double[][]{VectorFactory.superDiagonal(a4).toArray(), VectorFactory.diagonal(a4).toArray()});
                GolubKahanSVDStep a16 = new GolubKahanSVDStep((BidiagonalMatrix)a3);
                a4 = a16.UtBV().toDense();
                if (a5.goto) {
                    a10.add(a5.new MultiplyGivensMatrices(a16.getGivensMatricesForU(), a13));
                    a11.add(a5.new MultiplyGivensMatrices(a16.getGivensMatricesForV(), a13));
                }
            }
            a5.do(a9, a4, a13, a12);
        }
        if (a14 == a5.int) {
            throw new RuntimeException(String.format("diagonalization cannot converge in %d iterations", a5.int));
        }
        a5.break = new DiagonalMatrix(VectorFactory.diagonal(a9).toArray());
        if (a5.goto) {
            Matrix a17;
            a4 = a17 = a5.short(a10);
            if (a5.const > a5.enum) {
                a4 = MatrixFactory.rbind(a17, new DenseMatrix(a5.const - a5.enum, a5.enum));
            }
            a5.else = a7.multiply(a4);
            a5.super = a5.else.t();
            a3 = a5.short(a11);
            a5.class = a8.multiply((Matrix)a3);
        }
        if (a5.final) {
            if (a5.goto) {
                a5.short();
            } else {
                a5.do();
            }
        }
    }

    private double[] do(double[] a2) {
        for (int a3 = 0; a3 < a2.length; ++a3) {
            if (!(a2[a3] < 0.0)) continue;
            int n = a3;
            a2[n] = a2[n] * -1.0;
        }
        return a2;
    }

    private Matrix case(final List<UVOperation> a2) {
        GolubKahanSVD a3;
        int a4 = 4;
        final int a5 = (int)Math.ceil((double)a2.size() / 4.0);
        ArrayList<1> a6 = new ArrayList<1>(4);
        int a7 = 0;
        while (a7 < 4) {
            final int a8 = a7++;
            a6.add(new Callable<Matrix>(){
                {
                    1 a3;
                }

                @Override
                public Matrix call() throws Exception {
                    int a22 = a8 * a5;
                    int a3 = Math.min(a22 + a5, a2.size());
                    return GolubKahanSVD.this.do(a2.subList(a22, a3));
                }
            });
        }
        try {
            List a9 = catch.executeAll(a6);
            Matrix a10 = (Matrix)a9.get(0);
            for (int a11 = 1; a11 < a9.size(); ++a11) {
                a10 = a10.multiply((Matrix)a9.get(a11));
            }
            return a10;
        }
        catch (MultipleExecutionException a12) {
            return a3.do(a2);
        }
    }

    private void do(Matrix a2, List<GivensMatrix> a3, int a4) {
        for (GivensMatrix a5 : a3) {
            GolubKahanSVD a6;
            int a7 = a5.i() + a4 - 1;
            int a8 = a5.j() + a4 - 1;
            GivensMatrix a9 = new GivensMatrix(a6.enum, a7, a8, a5.c(), a5.s());
            a9.rightMultiplyInPlace(a2);
        }
    }

    private void do(Matrix a2, Matrix a3, int a4) {
        GolubKahanSVD a5;
        double a6 = a3.get(1, 1);
        double a7 = a3.get(1, 2);
        double a8 = a3.get(2, 1);
        double a9 = a3.get(2, 2);
        int a10 = a4;
        int a11 = a10 + 1;
        for (int a12 = 1; a12 <= a5.enum; ++a12) {
            double a13 = a2.get(a12, a10);
            double a14 = a2.get(a12, a11);
            a2.set(a12, a10, a13 * a6 + a14 * a8);
            a2.set(a12, a11, a13 * a7 + a14 * a9);
        }
    }

    private void short() {
        int a2;
        GolubKahanSVD a3;
        int a4 = a3.break.nRows();
        class UDVt {
            Vector vt;
            Double sv;
            Vector u;

            UDVt(Double a3, Vector a4, Vector a5) {
                UDVt a6;
                a6.sv = a3;
                a6.u = a4;
                a6.vt = a5;
            }
        }
        UDVt[] a5 = new UDVt[a4];
        for (int a6 = 1; a6 <= a4; ++a6) {
            double a7 = a3.break.get(a6, a6);
            a5[a6 - 1] = a3.new UDVt(a7 < 0.0 ? -a7 : a7, a7 < 0.0 ? a3.super.getRow(a6).scaled(-1.0) : a3.super.getRow(a6), a3.class.getColumn(a6));
        }
        class UtDVComparator
        implements Comparator<UDVt> {
            @Override
            public int compare(UDVt sv1, UDVt sv2) {
                return -1 * Double.compare(sv1.sv, sv2.sv);
            }

            UtDVComparator() {
                UtDVComparator a3;
            }
        }
        Arrays.sort(a5, a3.new UtDVComparator());
        Vector[] a8 = new Vector[a3.super.nRows()];
        Vector[] a9 = new Vector[a3.class.nCols()];
        for (a2 = 0; a2 < a4; ++a2) {
            a8[a2] = a5[a2].u;
            a3.break.set(a2 + 1, a2 + 1, a5[a2].sv);
            a9[a2] = a5[a2].vt;
        }
        for (a2 = a4; a2 < a3.super.nRows(); ++a2) {
            a8[a2] = new DenseVector(a3.super.nCols());
        }
        a3.super = MatrixFactory.rbind(a8);
        a3.class = MatrixFactory.cbind(a9);
    }

    private boolean short(Matrix a2, int a3, double a4) {
        double a5 = Math.abs(a2.get(a3, a3 + 1));
        return DoubleUtils.compare(a5, 0.0, a4) == 0;
    }

    public GolubKahanSVD(Matrix A2, boolean doUV, boolean normalize, double epsilon) {
        this(A2, doUV, normalize, epsilon, Integer.MAX_VALUE);
    }

    private List<GivensMatrix> short(Matrix a2) {
        int a3;
        int a4 = a2.nCols();
        for (a3 = 1; a3 < a4; ++a3) {
            GolubKahanSVD a5;
            if (!DoubleUtils.isZero(a2.get(a3, a3), a5.void) || DoubleUtils.isZero(a2.get(a3, a3 + 1), a5.void)) continue;
            a2.set(a3, a3, 0.0);
            break;
        }
        if (a3 >= a4) {
            throw new RuntimeException("no zero diagonal entry");
        }
        ArrayList<GivensMatrix> a6 = new ArrayList<GivensMatrix>(a4 - a3);
        for (int a7 = a3 + 1; a7 <= a4; ++a7) {
            GivensMatrix a8 = GivensMatrix.CtorToRotateRows(a4, a7, a3, a2.get(a7, a7), a2.get(a3, a7));
            a8.multiplyInPlace(a2);
            a6.add(a8.t());
        }
        return a6;
    }

    @Override
    public Matrix Ut() {
        ExceptionUtils.throwIfNotNull(this.goto ? null : new RuntimeException("only singular values were computed; U not available"));
        return this.super.deepCopy();
    }

    @Override
    public Matrix V() {
        ExceptionUtils.throwIfNotNull(this.goto ? null : new RuntimeException("only singular values were computed; V not available"));
        return this.class.deepCopy();
    }

    private Matrix short(List<UVOperation> a2) {
        GolubKahanSVD a3;
        if (a2.size() < new) {
            return a3.do(a2);
        }
        return a3.case(a2);
    }

    private List<GivensMatrix> do(Matrix a2) {
        int a3;
        int a4 = a2.nRows();
        ArrayList<GivensMatrix> a5 = new ArrayList<GivensMatrix>(a4 - 1);
        for (a3 = a4 - 1; a3 >= 1; --a3) {
            GivensMatrix a6 = GivensMatrix.CtorToRotateColumns(a4, a3, a4, a2.get(a3, a3), a2.get(a3, a4));
            a6.rightMultiplyInPlace(a2);
            a5.add(a6);
        }
        for (a3 = a4; a3 >= 1; --a3) {
            a2.set(a3, a4, 0.0);
        }
        return a5;
    }

    private boolean do(Matrix a2, int a3, double a4) {
        GolubKahanSVD a5;
        boolean a6 = a5.short(a2, a3, a4);
        if (a6) {
            a2.set(a3, a3 + 1, 0.0);
        }
        return a6;
    }

    private void do(Matrix a2) {
        int a3 = Math.min(a2.nRows(), a2.nCols());
        for (int a4 = 1; a4 <= a3 - 1; ++a4) {
            GolubKahanSVD a5;
            a5.do(a2, a4, a5.void);
        }
    }

    static {
        catch = new ParallelExecutor(GolubKahanSVD.class.getSimpleName());
        new = 500;
    }

    @Override
    public double[] getSingularValues() {
        double[] a2 = this.break.getDiagonal().toArray();
        return this.final ? a2 : this.do(a2);
    }

    @Override
    public Matrix U() {
        ExceptionUtils.throwIfNotNull(this.goto ? null : new RuntimeException("only singular values were computed; U not available"));
        return this.super.t();
    }

    private Matrix do(Matrix a2, int a3, int a4) {
        int a5 = a4 - a3 + 1;
        DenseMatrix a6 = new DenseMatrix(a5, a5);
        int a7 = 1;
        for (int a8 = a3; a8 < a4; ++a8) {
            a6.set(a7, a7, a2.get(a8, a8));
            a6.set(a7, a7 + 1, a2.get(a8, a8 + 1));
            ++a7;
        }
        a6.set(a5, a5, a2.get(a4, a4));
        return a6;
    }

    private void do() {
        GolubKahanSVD a2;
        double[] a3 = a2.break.getDiagonal().toArray();
        a2.do(a3);
        Arrays.sort(a3);
        DoubleUtils.reverse(a3);
        a2.break = new DiagonalMatrix(a3);
    }

    @Override
    public DiagonalMatrix D() {
        return new DiagonalMatrix(this.break);
    }

    private Matrix do(List<UVOperation> a2) {
        GolubKahanSVD a3;
        Matrix a4 = MatrixFactory.identity(a3.enum, a3.enum);
        for (UVOperation a5 : a2) {
            a5.doOperation(a4);
        }
        return a4;
    }

    private void do(Matrix a2, Matrix a3, int a4, int a5) {
        int a6 = a3.nRows();
        int a7 = 1;
        for (int a8 = a4; a8 < a5; ++a8) {
            a2.set(a8, a8, a3.get(a7, a7));
            a2.set(a8, a8 + 1, a3.get(a7, a7 + 1));
            ++a7;
        }
        a2.set(a5, a5, a3.get(a6, a6));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class MultiplyGivensMatrices
    implements UVOperation {
        private final List<GivensMatrix> goto;
        private final int enum;

        private MultiplyGivensMatrices(List<GivensMatrix> a2, int a3) {
            MultiplyGivensMatrices a4;
            a4.goto = a2;
            a4.enum = a3;
        }

        @Override
        public void doOperation(Matrix UorV) {
            GolubKahanSVD.this.do(UorV, this.goto, this.enum);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class Multiply2x2Block
    implements UVOperation {
        private final int goto;
        private final Matrix enum;

        @Override
        public void doOperation(Matrix UorV) {
            GolubKahanSVD.this.do(UorV, this.enum, this.goto);
        }

        private Multiply2x2Block(Matrix a2, int a3) {
            Multiply2x2Block a4;
            a4.enum = a2;
            a4.goto = a3;
        }
    }

    private static interface UVOperation {
        public void doOperation(Matrix var1);
    }
}

