/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.diagonalization.SymmetricTridiagonalDecomposition;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.MR3;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import java.util.Arrays;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SymmetricEigenByMR3
implements Spectrum {
    private final Matrix goto;
    private final MR3 enum;

    public SymmetricEigenByMR3(Matrix A2, boolean wantEigenvector) {
        this(A2, wantEigenvector, PrecisionUtils.autoEpsilon(A2));
    }

    public List<Vector> getEigenvectors() {
        List<Vector> a2 = Arrays.asList(MatrixUtils.toColumns(this.getEigenvectorMatrix()));
        return a2;
    }

    public List<Double> getEigenvalues() {
        return this.enum.getEigenvalues();
    }

    public Matrix getEigenvectorMatrix() {
        return this.goto.multiply(this.enum.getEigenvectorMatrix());
    }

    public SymmetricEigenByMR3(Matrix A2, boolean wantEigenvector, double epsilon) {
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(A2, epsilon), "MR3 algorithm applies only to symmetric matrix", new Object[0]);
        Matrix a2 = A2 instanceof SymmetricMatrix ? A2 : new SymmetricMatrix(A2);
        SymmetricTridiagonalDecomposition a3 = new SymmetricTridiagonalDecomposition(a2);
        TridiagonalMatrix a4 = a3.T();
        this.goto = a3.Q();
        this.enum = new MR3(a4.getDiagonal(), a4.getSubDiagonal(), wantEigenvector);
    }
}

