/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.trend.dai2011;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.license.Package;
import dev.nm.stat.hmm.HMMRNG;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import dev.nm.stat.stochasticprocess.univariate.random.RandomWalk;
import dev.nm.stat.stochasticprocess.univariate.sde.discrete.BMSDE;
import dev.nm.stat.stochasticprocess.univariate.sde.discrete.DiscreteSDE;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Dai2011HMM {
    private final ModelParam class;
    private static final int goto = 2;
    private final double enum;

    static {
        Package.validate("ALGOQUANT_DAI2011");
    }

    public HMMRNG getHMM() {
        DenseVector a2 = new DenseVector(0.5, 0.5);
        double a3 = this.lambda1() * this.class.dt;
        double a4 = this.lambda2() * this.class.dt;
        DenseMatrix a5 = new DenseMatrix(new double[][]{{1.0 - a3, a3}, {a4, 1.0 - a4}});
        RandomWalk a6 = new RandomWalk((DiscreteSDE)new BMSDE(this.mu1(), this.sigma()), this.class.dt, 10000.0);
        RandomWalk a7 = new RandomWalk((DiscreteSDE)new BMSDE(this.mu2(), this.sigma()), this.class.dt, 10000.0);
        RandomNumberGenerator[] a8 = new RandomNumberGenerator[]{a6, a7};
        HMMRNG a9 = new HMMRNG(a2, a5, a8);
        return a9;
    }

    public Dai2011HMM(ModelParam model) {
        this.class = model;
        this.enum = model.sigma * model.sigma;
    }

    private double do(double a2) {
        Dai2011HMM a3;
        double a4 = -(a3.lambda1() + a3.lambda2()) * a2 + a3.lambda2();
        double a5 = (a3.mu1() - a3.mu2()) * a2 * (1.0 - a2);
        a5 *= (a3.mu1() - a3.mu2()) * a2 + a3.mu2() - a3.enum / 2.0;
        return a4 -= (a5 /= a3.enum);
    }

    public double sigma() {
        return this.class.sigma;
    }

    public Dai2011HMM getReciprocal() {
        return new Dai2011HMM(this.enum - this.mu2(), this.enum - this.mu1(), this.lambda2(), this.lambda1(), this.sigma());
    }

    public double lambda1() {
        return this.class.lambda1;
    }

    public double mu2() {
        return this.class.mu2;
    }

    public double mu1() {
        return this.class.mu1;
    }

    public double nextX(double xt, double St, double newSt) {
        double a2 = this.class.dt;
        double a3 = (this.mu1() - this.mu2()) / this.enum;
        double a4 = xt;
        a4 += Math.log(newSt / St) * a3;
        a4 -= a2 * a3 * (this.mu1() - this.enum / 2.0);
        a4 -= a2 * (this.lambda1() - this.lambda2());
        return a4 += a2 * (this.lambda2() * Math.exp(-xt) - this.lambda1() * Math.exp(xt) + a3 * (this.mu1() - this.mu2()) / (1.0 + Math.exp(xt)));
    }

    public Dai2011HMM(double mu1, double mu2, double lambda1, double lambda2, double sigma) {
        this(new ModelParam(mu1, mu2, lambda1, lambda2, sigma));
    }

    public double lambda2() {
        return this.class.lambda2;
    }

    public double nextP(double pt, double St, double St1) {
        double a2 = (this.mu1() - this.mu2()) * pt * (1.0 - pt) / this.enum;
        a2 *= Math.log(St1 / St);
        double a3 = this.do(pt);
        double a4 = pt + (a2 += a3 * this.class.dt);
        a4 = a4 > 0.0 ? (a4 < 1.0 ? a4 : 1.0) : 0.0;
        return a4;
    }

    public Dai2011HMM(Dai2011HMM that) {
        this(that.class.mu1, that.class.mu2, that.class.lambda1, that.class.lambda2, that.class.sigma);
    }

    public String toString() {
        return String.format("Dai 2011 HMM: \nin uptrend state: drift = %f, lambda1 = %f\nin downtrend state: drift = %f, lambda2 = %f\nvolatility = %f", this.mu1(), this.lambda1(), this.mu2(), this.lambda2(), this.sigma());
    }

    public static class CalibrationParam
    extends ModelParam {
        public final double avg_duration1;
        public final double avg_duration2;
        public final double drift1;
        public final double drift2;
        public final double var;

        public CalibrationParam(double drift1, double drift2, double avg_duration1, double avg_duration2, double var, double dt) {
            super((drift1 + 0.5 * var) / dt, (drift2 + 0.5 * var) / dt, 1.0 / avg_duration1 / dt, 1.0 / avg_duration2 / dt, Math.sqrt(var / dt), dt);
            this.drift1 = drift1;
            this.drift2 = drift2;
            this.avg_duration1 = avg_duration1;
            this.avg_duration2 = avg_duration2;
            this.var = var;
        }
    }

    public static class ModelParam {
        public final double mu1;
        public final double sigma;
        public final double mu2;
        public final double lambda1;
        public final double lambda2;
        public final double dt;

        public ModelParam(double mu1, double mu2, double lambda1, double lambda2, double sigma) {
            this(mu1, mu2, lambda1, lambda2, sigma, 0.003968253968253968);
        }

        public ModelParam(double mu1, double mu2, double lambda1, double lambda2, double sigma, double dt) {
            this.mu1 = mu1;
            this.mu2 = mu2;
            this.lambda1 = lambda1;
            this.lambda2 = lambda2;
            this.sigma = sigma;
            this.dt = dt;
        }
    }
}

