/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.meanreversion.cointegration;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.stat.descriptive.moment.Mean;
import dev.nm.stat.descriptive.moment.Variance;
import java.util.Arrays;
import tech.nmfin.meanreversion.cointegration.PairingModelUtils;
import tech.nmfin.meanreversion.cointegration.check.CorrelationCheck;

public class TradingPair {
    protected final Vector price1;
    protected final String symbol1;
    protected final Vector price2;
    protected final double beta;
    protected final String symbol2;
    protected Vector spread = null;
    protected Matrix returns = null;

    public TradingPair(String symbol1, String symbol2, Vector price1, Vector price2, double beta) {
        this.symbol1 = symbol1;
        this.symbol2 = symbol2;
        this.price1 = price1;
        this.price2 = price2;
        this.beta = beta;
    }

    public Vector spread() {
        if (this.spread != null) {
            return this.spread;
        }
        this.spread = this.price1.add(this.price2.scaled(this.beta));
        return this.spread;
    }

    public double mean() {
        return new Mean(this.spread().toArray()).value();
    }

    public String symbol2() {
        return this.symbol2;
    }

    public double stdev(double tailed) {
        double[] a2 = this.spread().toArray();
        Variance a3 = new Variance(Arrays.copyOfRange(a2, Math.max(1, (int)((double)a2.length * (1.0 - tailed))), a2.length));
        double a4 = a3.standardDeviation();
        return a4;
    }

    public double cor(double tailed) {
        Matrix a2 = PairingModelUtils.getPriceMatrix(this.price1, this.price2);
        double a3 = CorrelationCheck.cor(a2, tailed);
        return a3;
    }

    public double beta() {
        return this.beta;
    }

    static {
        Package.validate("ALGOQUANT_COINTEGRATION");
    }

    public double stdev() {
        return this.stdev(1.0);
    }

    public String symbol1() {
        return this.symbol1;
    }

    public String toString() {
        String a2 = String.format("%s + %f%s", this.symbol1, this.beta, this.symbol2);
        return a2;
    }
}

