/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.univariate.stationaryprocess.arma;

import dev.nm.stat.timeseries.linear.univariate.arima.ARIMAModel;
import java.util.Arrays;

public class ARMAModel
extends ARIMAModel {
    public ARMAModel(double mu, double[] AR, double[] MA) {
        this(mu, AR, MA, 1.0);
    }

    public ARMAModel(double mu, double[] AR, double[] MA, double sigma) {
        super(mu, AR, 0, MA, sigma);
    }

    public double unconditionalMean() {
        int a2 = this.p();
        if (a2 == 0) {
            return this.mu();
        }
        double a3 = 0.0;
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3 += this.AR(a4);
        }
        double a5 = this.mu() / (1.0 - a3);
        return a5;
    }

    public ARMAModel(double[] AR, double[] MA) {
        this(AR, MA, 1.0);
    }

    public double conditionalMean(double[] arLags, double[] maLags) {
        double a2 = 0.0;
        if (arLags != null) {
            for (int a3 = 0; a3 < arLags.length; ++a3) {
                a2 += this.AR(a3 + 1) * arLags[a3];
            }
        }
        double a4 = 0.0;
        if (maLags != null) {
            for (int a5 = 0; a5 < maLags.length; ++a5) {
                a4 += this.MA(a5 + 1) * maLags[a5];
            }
        }
        double a6 = a2 + a4;
        double a7 = this.mu() + a6;
        return a7;
    }

    public ARMAModel(ARMAModel that) {
        super(that);
    }

    public ARMAModel getDemeanedModel() {
        double[] a2 = this.phi();
        double[] a3 = this.theta();
        return new ARMAModel(Arrays.copyOfRange(a2, 1, a2.length), Arrays.copyOfRange(a3, 1, a3.length));
    }

    public ARMAModel(double[] AR, double[] MA, double sigma) {
        this(0.0, AR, MA, sigma);
    }
}

