/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.timeseries.linear.multivariate.arima;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.misc.ArrayUtils;
import dev.nm.stat.random.rng.multivariate.IID;
import dev.nm.stat.random.rng.multivariate.RandomVectorGenerator;
import dev.nm.stat.random.rng.univariate.normal.StandardNormalRNG;
import dev.nm.stat.timeseries.linear.multivariate.arima.VARIMAModel;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VARIMASim
implements RandomVectorGenerator {
    private Vector[] const;
    private final VARIMAModel void;
    private Vector[] class;
    private Vector[] goto;
    private final RandomVectorGenerator enum;

    public VARIMASim(VARIMAModel arima) {
        this(arima, new IID(new StandardNormalRNG(), arima.dimension()));
    }

    @Override
    public void seed(long ... seeds) {
        this.enum.seed(seeds);
    }

    public VARIMASim(VARIMAModel arima, Vector[] lags, Vector[] innovations, RandomVectorGenerator rvg) {
        this.void = arima;
        this.class = Arrays.copyOf(lags, arima.p());
        this.const = Arrays.copyOf(innovations, arima.q());
        this.goto = new Vector[arima.d() + 1];
        for (int a2 = 0; a2 < this.goto.length; ++a2) {
            this.goto[a2] = new DenseVector(arima.dimension());
        }
        if (lags != null && lags.length > 0) {
            this.goto[0] = new ImmutableVector(lags[0]);
            Vector[] a3 = Arrays.copyOf(lags, lags.length);
            ArrayUtils.reverse(a3);
            for (int a4 = 1; a4 <= arima.d(); ++a4) {
                a3 = VectorFactory.cumsum(a3);
                this.goto[a4] = a3[a3.length - 1];
            }
        }
        this.enum = rvg;
    }

    public VARIMASim(VARIMAModel arima, RandomVectorGenerator rvg) {
        this(arima, VectorFactory.get0s(arima.dimension(), arima.p()), VectorFactory.get0s(arima.dimension(), arima.q()), rvg);
    }

    @Override
    public double[] nextVector() {
        Vector a2;
        DenseVector a3 = new DenseVector(this.enum.nextVector());
        Matrix a4 = this.class != null && this.class.length > 0 ? MatrixFactory.cbind(this.class) : new DenseMatrix(new DenseVector(this.void.dimension()));
        Matrix a5 = this.const != null && this.const.length > 0 ? MatrixFactory.cbind(this.const) : new DenseMatrix(new DenseVector(this.void.dimension()));
        this.goto[0] = a2 = this.void.getVARMA().conditionalMean(a4, a5).add(a3);
        for (int a6 = 1; a6 <= this.void.d(); ++a6) {
            this.goto[a6] = this.goto[a6].add(this.goto[a6 - 1]);
        }
        if (this.class.length > 0) {
            this.class = ArrayUtils.rightShift(this.class);
            this.class[0] = a2;
        }
        if (this.const.length > 0) {
            this.const = ArrayUtils.rightShift(this.const);
            this.const[0] = a3;
        }
        return this.goto[this.void.d()].toArray();
    }
}

