/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.logistic;

import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.solver.multivariate.unconstrained.c2.IterativeC2Maximizer;
import dev.nm.solver.problem.C2OptimProblemImpl;
import dev.nm.stat.regression.linear.LMProblem;
import dev.nm.stat.regression.linear.LinearModel;
import dev.nm.stat.regression.linear.logistic.LogisticBeta;
import dev.nm.stat.regression.linear.logistic.LogisticProblem;
import dev.nm.stat.regression.linear.logistic.LogisticResiduals;
import dev.nm.stat.regression.linear.ols.OLSRegression;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogisticRegression
implements LinearModel {
    private final LogisticProblem goto;
    private final ImmutableVector enum;

    public LogisticRegression(LogisticProblem problem) {
        this.goto = problem;
        try {
            int a2 = problem.nFactors();
            RealScalarFunction a3 = LogisticRegression.logLikelihood(this.goto);
            IterativeC2Maximizer a4 = new IterativeC2Maximizer(0.0, 200);
            IterativeC2Maximizer.Solution a5 = a4.solve(new C2OptimProblemImpl(a3));
            this.enum = new ImmutableVector(a5.search(new DenseVector(a2)));
        }
        catch (Exception a6) {
            throw new RuntimeException("cannot compute betaHat");
        }
    }

    @Override
    public double Ey(Vector x) {
        return OLSRegression.Ey(this.enum, x, this.goto.intercept());
    }

    public static RealScalarFunction logLikelihood(final LogisticProblem problem) {
        return new AbstractRealScalarFunction(problem.nFactors()){
            {
                1 a3;
                super(a2);
            }

            @Override
            public Double evaluate(Vector b2) {
                Vector a2 = problem.A().multiply(b2);
                double a3 = 0.0;
                for (int a4 = 1; a4 <= problem.nObs(); ++a4) {
                    a3 += problem.y().get(a4) * a2.get(a4) - Math.log(1.0 + Math.exp(a2.get(a4)));
                }
                return a3;
            }
        };
    }

    public double AIC() {
        int a2 = this.goto.nFactors();
        double a3 = (double)(2 * a2) - 2.0 * this.ML();
        return a3;
    }

    @Override
    public LogisticResiduals residuals() {
        LogisticResiduals a2 = new LogisticResiduals(this.goto, (Vector)this.enum);
        return a2;
    }

    @Override
    public LogisticBeta beta() {
        LogisticBeta a2 = new LogisticBeta(this.enum, this.residuals());
        return a2;
    }

    public double ML() {
        RealScalarFunction a2 = LogisticRegression.logLikelihood(this.goto);
        double a3 = (Double)a2.evaluate(this.enum);
        return a3;
    }

    public LogisticRegression(LMProblem problem) {
        this(new LogisticProblem(problem));
    }
}

