/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LMProblem {
    private final ImmutableVector else;
    private final ImmutableMatrix catch;
    private final ImmutableVector const;
    private final ImmutableMatrix void;
    private final boolean class;
    private volatile ImmutableMatrix goto = null;
    private final ImmutableVector enum;

    public LMProblem(LMProblem that) {
        this.const = new ImmutableVector(that.const);
        this.void = new ImmutableMatrix(that.void);
        this.enum = new ImmutableVector(that.enum);
        this.catch = new ImmutableMatrix(that.catch);
        this.class = that.class;
        this.else = that.else == null ? null : new ImmutableVector(that.else);
    }

    public ImmutableMatrix A() {
        return this.void;
    }

    public boolean intercept() {
        return this.class;
    }

    public LMProblem(Vector y, Matrix X) {
        this(y, X, true, null);
    }

    public ImmutableVector wy() {
        return this.enum;
    }

    public ImmutableVector weights() {
        return this.else;
    }

    public int nFactors() {
        return this.void.nCols();
    }

    public ImmutableMatrix X() {
        Matrix a2 = !this.class ? this.void : new SubMatrixRef(this.void, 1, this.void.nRows(), 1, this.void.nCols() - 1);
        return new ImmutableMatrix(a2);
    }

    protected void checkInputs() {
        ArgumentAssertion.assertTrue(this.const.size() == this.void.nRows(), "y and A do not have the same number of rows", new Object[0]);
        if (this.else != null) {
            ArgumentAssertion.assertTrue(this.else.size() == this.const.size(), "weights and y do not have the same number of rows", new Object[0]);
            for (int a2 = 1; a2 <= this.else.size(); ++a2) {
                ArgumentAssertion.assertTrue(this.else.get(a2) >= 0.0, "all weights must be non negative", new Object[0]);
            }
        }
    }

    public ImmutableVector y() {
        return this.const;
    }

    public LMProblem(Vector y, Matrix X, boolean intercept, Vector weights) {
        this.const = !(y instanceof ImmutableVector) ? new ImmutableVector(y) : (ImmutableVector)y;
        this.class = intercept;
        this.void = new ImmutableMatrix(!intercept ? X : MatrixFactory.cbind(X, new DenseMatrix(DoubleUtils.rep(1.0, X.nRows()), X.nRows(), 1)));
        ImmutableVector immutableVector = weights != null ? (!(weights instanceof ImmutableVector) ? new ImmutableVector(weights) : (ImmutableVector)weights) : (this.else = null);
        if (weights != null) {
            Vector a2 = weights.pow(0.5);
            DiagonalMatrix a3 = new DiagonalMatrix(a2.toArray());
            this.catch = new ImmutableMatrix(a3.multiply(this.void));
            this.enum = new ImmutableVector(y.multiply(a2));
        } else {
            this.catch = this.void;
            this.enum = this.const;
        }
        this.checkInputs();
    }

    public ImmutableMatrix wA() {
        return this.catch;
    }

    public ImmutableMatrix invOfwAtwA() {
        if (this.goto == null) {
            this.goto = new ImmutableMatrix(new Inverse(this.catch.t().multiply(this.catch), 0.0));
        }
        return this.goto;
    }

    public LMProblem(Vector y, Matrix X, boolean intercept) {
        this(y, X, intercept, null);
    }

    public int nExogenousFactors() {
        return this.void.nCols() - (this.class ? 1 : 0);
    }

    public LMProblem(Vector y, Matrix X, Vector weights) {
        this(y, X, true, weights);
    }

    public int nObs() {
        return this.void.nRows();
    }
}

