/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.random.rng.univariate.uniform.linear;

import dev.nm.analysis.function.FunctionOps;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.random.rng.univariate.uniform.linear.LinearCongruentialGenerator;
import java.util.concurrent.atomic.AtomicLong;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Lehmer
implements LinearCongruentialGenerator {
    private final long const;
    private final long void;
    private final long class;
    private final long goto;
    private AtomicLong enum = new AtomicLong();

    public Lehmer(long a2, long m2, long seed) {
        ArgumentAssertion.assertPositive(a2, "a");
        ArgumentAssertion.assertPositive(m2, "m");
        this.void = a2;
        this.const = m2;
        this.class = m2 / a2;
        this.goto = m2 % a2;
        ArgumentAssertion.assertTrue(this.goto <= this.class, "the (a, m) combination is not valid; try a <= sqrt(m)", new Object[0]);
        this.seed(seed);
    }

    @Override
    public void seed(long ... seeds) {
        this.enum.set(seeds[0] % this.const);
    }

    @Override
    public int order() {
        return 1;
    }

    @Override
    public long nextLong() {
        long a2;
        long a3;
        do {
            a2 = a3 = this.enum.get();
            long a4 = a2 / this.class;
            if ((a2 = this.void * (a2 - a4 * this.class) - a4 * this.goto) >= 0L) continue;
            a2 += this.const;
        } while (!this.enum.compareAndSet(a3, a2));
        return a2;
    }

    public Lehmer() {
        this(40014L, 2147483563L, 8682522807148012L + System.nanoTime());
    }

    @Override
    public long modulus() {
        return this.const;
    }

    @Override
    public double nextDouble() {
        return (double)this.nextLong() / (double)this.const;
    }

    public Lehmer(long a2, long m2, long k2, long seed) {
        this(FunctionOps.modpow(a2, k2, m2), m2, seed);
    }
}

