/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.hmm.mixture.distribution;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.stat.distribution.univariate.BinomialDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.hmm.mixture.distribution.MixtureDistribution;
import dev.nm.stat.random.rng.univariate.BinomialRNG;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BinomialMixtureDistribution
implements MixtureDistribution {
    private final Lambda[] enum;

    @Override
    public MixtureDistribution newMixtureDistribution(Object[] param) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param, param.length);
        return new BinomialMixtureDistribution(a2);
    }

    public Lambda[] getMStepParams(double[] observations, Vector[] u) {
        int a2 = u.length;
        int a3 = u[0].size();
        Lambda[] a4 = new Lambda[this.enum.length];
        for (int a5 = 0; a5 < a3; ++a5) {
            int a6 = this.enum[a5].size;
            double a7 = 0.0;
            double a8 = 0.0;
            for (int a9 = 0; a9 < a2; ++a9) {
                double a10 = u[a9].get(a5 + 1);
                a7 += a10 * observations[a9];
                a8 += a10 * (double)a6;
            }
            double a11 = a7 / a8;
            a4[a5] = new Lambda(a6, a11);
        }
        return a4;
    }

    public BinomialMixtureDistribution(Lambda[] lambda) {
        this.enum = Arrays.copyOf(lambda, lambda.length);
    }

    @Override
    public ProbabilityDistribution[] newDistributions() {
        ProbabilityDistribution[] a2 = new ProbabilityDistribution[this.enum.length];
        for (int a3 = 0; a3 < this.enum.length; ++a3) {
            int a4 = this.enum[a3].size;
            double a5 = this.enum[a3].p;
            a2[a3] = new BinomialDistribution(a4, a5);
        }
        return a2;
    }

    @Override
    public RandomNumberGenerator[] newRandomNumberGenerators() {
        RandomNumberGenerator[] a2 = new RandomNumberGenerator[this.enum.length];
        for (int a3 = 0; a3 < this.enum.length; ++a3) {
            int a4 = this.enum[a3].size;
            double a5 = this.enum[a3].p;
            a2[a3] = new BinomialRNG(a4, a5);
        }
        return a2;
    }

    public Lambda[] getParams() {
        Lambda[] a2 = Arrays.copyOf(this.enum, this.enum.length);
        return a2;
    }

    public static class Lambda {
        public final double p;
        public final int size;

        public Lambda(int size, double p) {
            this.size = size;
            this.p = p;
        }
    }
}

