/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.dlm.multivariate;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.dlm.multivariate.MultivariateObservationEquation;
import dev.nm.stat.dlm.multivariate.MultivariateStateEquation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateDLM {
    private final ImmutableVector catch;
    private final MultivariateStateEquation const;
    private final ImmutableMatrix void;
    private final MultivariateObservationEquation class;
    private final int goto;
    private final int enum;

    public MultivariateDLM(Vector m0, Matrix C0, MultivariateObservationEquation Yt, MultivariateStateEquation Xt) {
        ArgumentAssertion.assertTrue(m0 != null && C0 != null, "the distribution of the initial state x_0 ~ N(m0, C0) must be specified", new Object[0]);
        this.goto = m0.size();
        this.enum = Yt.dimension();
        this.catch = new ImmutableVector(m0);
        ArgumentAssertion.assertTrue(C0.nRows() == this.goto && C0.nCols() == this.goto, "the dimension of C0 is p x p; p = the length of an observation", new Object[0]);
        this.void = new ImmutableMatrix(C0);
        ArgumentAssertion.assertTrue(Yt.dimension() == this.enum, "the dimension of the observation equation is d, the same length as m0", new Object[0]);
        ArgumentAssertion.assertTrue(Yt.F(1).nCols() == this.goto, "the dimension of F is d x p, i.e., the length of m0 * the length of an observation", new Object[0]);
        this.class = Yt;
        ArgumentAssertion.assertTrue(Xt.dimension() == this.goto, "the dimension of the state equation is p; p = the length of an observation", new Object[0]);
        this.const = Xt;
    }

    public MultivariateDLM(MultivariateDLM that) {
        this(that.catch, that.void, that.class, that.const);
    }

    public int getStateDimension() {
        return this.goto;
    }

    public int getObsDimension() {
        return this.enum;
    }

    public MultivariateStateEquation getStateModel() {
        return this.const;
    }

    public ImmutableMatrix C0() {
        return this.void;
    }

    public ImmutableVector m0() {
        return this.catch;
    }

    public MultivariateObservationEquation getObservationModel() {
        return this.class;
    }
}

