/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogNormalDistribution
implements ProbabilityDistribution {
    private final double class;
    private final double goto;
    private final NormalDistribution enum;

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return this.enum.cdf(Math.log(x));
    }

    @Override
    public double entropy() {
        double a2 = 0.5;
        return a2 += 0.5 * Math.log(Math.PI * 2 * this.class * this.class) + this.goto;
    }

    @Override
    public double median() {
        return Math.exp(this.goto);
    }

    public LogNormalDistribution(double logMu, double logSigma) {
        ArgumentAssertion.assertPositive(logSigma, "logarithm of standard deviation");
        this.goto = logMu;
        this.class = logSigma;
        this.enum = new NormalDistribution(logMu, logSigma);
    }

    @Override
    public double skew() {
        double a2 = this.class * this.class;
        double a3 = Math.exp(a2);
        double a4 = a3 + 2.0;
        return a4 *= Math.sqrt(a3 - 1.0);
    }

    @Override
    public double quantile(double u) {
        return Math.exp(this.enum.quantile(u));
    }

    @Override
    public double mean() {
        double a2 = this.goto + this.class * this.class / 2.0;
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double variance() {
        double a2 = this.class * this.class;
        double a3 = Math.exp(a2) - 1.0;
        return a3 *= Math.exp(2.0 * this.goto + a2);
    }

    @Override
    public double kurtosis() {
        double a2 = this.class * this.class;
        double a3 = Math.exp(4.0 * a2);
        a3 += 2.0 * Math.exp(3.0 * a2);
        a3 += 3.0 * Math.exp(2.0 * a2);
        return a3 -= 6.0;
    }

    @Override
    public double moment(double s) {
        double a2 = s * this.goto;
        a2 += 0.5 * s * s * this.class * this.class;
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double a2 = this.enum.density(Math.log(x));
        return a2 /= x;
    }
}

