/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.covariance.nlshrink;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.solver.IterativeSolution;
import dev.nm.solver.multivariate.constrained.constraint.GreaterThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.general.GeneralGreaterThanConstraints;
import dev.nm.solver.multivariate.constrained.general.sqp.activeset.SQPActiveSetOnlyInequalityConstraintMinimizer;
import dev.nm.stat.covariance.nlshrink.quest.QuEST;
import dev.nm.stat.descriptive.rank.Rank;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TauEstimator {
    private final double const;
    private final Vector void;
    private int class;
    private final int goto;
    private final int enum;

    private GreaterThanConstraints do() {
        TauEstimator a2;
        final double a3 = a2.void.norm(Double.NEGATIVE_INFINITY);
        final double a4 = a2.void.norm(Double.POSITIVE_INFINITY);
        AbstractRealScalarFunction a5 = new AbstractRealScalarFunction(a2.goto){
            {
                1 a4;
                super(a32);
            }

            @Override
            public Double evaluate(Vector tau) {
                double a2 = DoubleArrayMath.min(tau.toArray()) - a3;
                return a2;
            }
        };
        AbstractRealScalarFunction a6 = new AbstractRealScalarFunction(a2.goto){

            @Override
            public Double evaluate(Vector tau) {
                double a2 = a4 - DoubleArrayMath.max(tau.toArray());
                return a2;
            }
            {
                2 a42;
                super(a3);
            }
        };
        GeneralGreaterThanConstraints a7 = new GeneralGreaterThanConstraints(a5, a6);
        return a7;
    }

    RealScalarFunction objectiveFunction() {
        TauEstimator a2;
        return new AbstractRealScalarFunction(a2.goto){
            {
                3 a4;
                super(a3);
            }

            @Override
            public Double evaluate(Vector tau0) {
                DenseVector a2 = new DenseVector(tau0);
                for (int a3 = 1; a3 <= a2.size(); ++a3) {
                    if (!(a2.get(a3) < 0.0)) continue;
                    if (a2.get(a3) > -TauEstimator.this.const) {
                        a2.set(a3, 0.0);
                        continue;
                    }
                    throw new RuntimeException("eigenvalues must be non negative: tau = " + a2);
                }
                QuEST.Result a4 = new QuEST(a2, TauEstimator.this.enum - 1).evaluate();
                double a5 = 0.0;
                for (int a6 = 1; a6 <= TauEstimator.this.goto; ++a6) {
                    double a7 = a4.estimated_lambda.get(a6) - TauEstimator.this.void.get(a6);
                    a5 += a7 * a7;
                }
                double a8 = a5 / (double)TauEstimator.this.goto;
                return a8;
            }
        };
    }

    public Vector estimatedPopulationEigenvalues(Vector initials) {
        try {
            RealScalarFunction a2 = this.objectiveFunction();
            RealVectorFunction a3 = this.gradientFunction();
            GreaterThanConstraints a4 = this.do();
            SQPActiveSetOnlyInequalityConstraintMinimizer a5 = new SQPActiveSetOnlyInequalityConstraintMinimizer(1.0E-12, this.class);
            IterativeSolution<Vector> a6 = a5.solve(a2, a3, a4);
            Vector a7 = a6.search((Vector[])new Vector[]{initials});
            double[] a8 = a7.toArray();
            Arrays.sort(a8);
            DenseVector a9 = new DenseVector(a8);
            return a9;
        }
        catch (Exception a10) {
            throw new RuntimeException("error in estimatedPopulationEigenvalues: " + a10);
        }
    }

    private Vector do(Vector a2, int[] a3) {
        DenseVector a4 = new DenseVector(a3.length);
        for (int a5 = 1; a5 <= a3.length; ++a5) {
            int a6 = a3[a5 - 1];
            a4.set(a5, a2.get(a6));
        }
        return a4;
    }

    public TauEstimator(int p, int n, Vector sample_lambdas) {
        this(p, n, sample_lambdas, 100, 1.0E-4);
    }

    public TauEstimator(int p, int n, Vector sample_lambdas, int max_optimizer_iterations, double epsilon) {
        this.goto = p;
        this.enum = n;
        this.class = max_optimizer_iterations;
        double[] a2 = sample_lambdas.toArray();
        Arrays.sort(a2);
        this.void = new DenseVector(a2);
        this.const = epsilon;
    }

    RealVectorFunction gradientFunction() {
        TauEstimator a2;
        return new RealVectorFunction(){

            @Override
            public int dimensionOfDomain() {
                return TauEstimator.this.goto;
            }

            @Override
            public int dimensionOfRange() {
                return TauEstimator.this.goto;
            }

            @Override
            public Vector evaluate(Vector tau0) {
                DenseVector a2 = new DenseVector(tau0);
                for (int a3 = 1; a3 <= a2.size(); ++a3) {
                    if (!(a2.get(a3) < 0.0)) continue;
                    if (a2.get(a3) > -TauEstimator.this.const) {
                        a2.set(a3, 0.0);
                        continue;
                    }
                    throw new RuntimeException("eigenvalues must be non negative: tau = " + a2);
                }
                int[] a4 = DoubleUtils.doubleArray2intArray(new Rank(a2.toArray(), Rank.TiesMethod.FIRST).ranks());
                QuEST.Result a5 = new QuEST(a2, TauEstimator.this.enum - 1).evaluate();
                Object a6 = a2.ZERO();
                for (int a7 = 1; a7 <= TauEstimator.this.goto; ++a7) {
                    double a8 = 0.0;
                    for (int a9 = 1; a9 <= TauEstimator.this.goto; ++a9) {
                        a8 += a5.lambda_Jacobian.get(a9, a7) * (a5.estimated_lambda.get(a9) - TauEstimator.this.void.get(a9));
                    }
                    a6.set(a7, a8 * 2.0 / (double)TauEstimator.this.goto);
                }
                a6 = TauEstimator.this.do((Vector)a6, a4);
                return a6;
            }
            {
                4 a3;
            }
        };
    }
}

