/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.simplex;

import dev.nm.algebra.linear.matrix.doubles.MatrixTable;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.datastructure.FlexibleTable;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;

public class JordanExchange {
    private static final int enum = 250000;

    public FlexibleTable swap(FlexibleTable A2, int r, int s) {
        int a2;
        FlexibleTable a3 = this.swap((MatrixTable)A2, r, s);
        for (a2 = 1; a2 <= a3.nRows(); ++a2) {
            a3.renameRow(a2, A2.getRowLabel(a2));
        }
        for (a2 = 1; a2 <= a3.nCols(); ++a2) {
            a3.renameCol(a2, A2.getColLabel(a2));
        }
        Object a4 = a3.getRowLabel(r);
        a3.renameRow(r, a3.getColLabel(s));
        a3.renameCol(s, a4);
        return a3;
    }

    public FlexibleTable swapInPlace(final FlexibleTable A2, final int r, final int s) {
        int a2;
        double a3 = A2.get(r, s);
        if (a3 == 0.0) {
            throw new RuntimeException(String.format("zero pivot found at [%d, %d] (linear dependence detected)", r, s));
        }
        final Vector a4 = A2.getRow(r);
        for (a2 = 1; a2 <= A2.nCols(); ++a2) {
            A2.set(r, a2, -A2.get(r, a2) / a3);
        }
        for (a2 = 1; a2 <= A2.nRows(); ++a2) {
            A2.set(a2, s, A2.get(a2, s) / a3);
        }
        A2.set(r, s, 1.0 / a3);
        if (A2.nRows() * A2.nCols() < 250000) {
            for (a2 = 1; a2 <= A2.nRows(); ++a2) {
                for (int a5 = 1; a5 <= A2.nCols(); ++a5) {
                    if (a2 == r || a5 == s) continue;
                    A2.set(a2, a5, A2.get(a2, a5) - A2.get(a2, s) * a4.get(a5));
                }
            }
        } else {
            try {
                ParallelExecutor.getSharedInstance().forLoop(1, A2.nRows() + 1, new LoopBody(){

                    @Override
                    public void run(int i2) throws Exception {
                        for (int a2 = 1; a2 <= A2.nCols(); ++a2) {
                            if (i2 == r || a2 == s) continue;
                            A2.set(i2, a2, A2.get(i2, a2) - A2.get(i2, s) * a4.get(a2));
                        }
                    }
                    {
                        1 a3;
                    }
                });
            }
            catch (MultipleExecutionException a6) {
                throw new RuntimeException(a6);
            }
        }
        Object a7 = A2.getRowLabel(r);
        A2.renameRow(r, A2.getColLabel(s));
        A2.renameCol(s, a7);
        return A2;
    }

    public FlexibleTable swap(MatrixTable A2, int r, int s) {
        int a2;
        FlexibleTable a3 = new FlexibleTable(A2.nRows(), A2.nCols());
        double a4 = A2.get(r, s);
        if (a4 == 0.0) {
            throw new RuntimeException(String.format("zero pivot found at [%d, %d] (linear dependence detected)", r, s));
        }
        for (a2 = 1; a2 <= A2.nCols(); ++a2) {
            a3.set(r, a2, -A2.get(r, a2) / a4);
        }
        for (a2 = 1; a2 <= A2.nRows(); ++a2) {
            a3.set(a2, s, A2.get(a2, s) / a4);
        }
        a3.set(r, s, 1.0 / a4);
        for (a2 = 1; a2 <= A2.nRows(); ++a2) {
            for (int a5 = 1; a5 <= A2.nCols(); ++a5) {
                if (a2 == r || a5 == s) continue;
                a3.set(a2, a5, A2.get(a2, a5) - a3.get(a2, s) * A2.get(r, a5));
            }
        }
        return a3;
    }
}

