/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskyBanachiewiczParallelized;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixRootByDiagonalization;
import dev.nm.algebra.linear.matrix.doubles.operation.VariancebtX;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraint;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPRiskConstraint;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PortfolioRiskExactSigma
extends SOCPRiskConstraint {
    private final Matrix goto;
    private final Matrix enum;

    public PortfolioRiskExactSigma(Matrix Sigma) {
        this(Sigma, new DefaultRoot());
    }

    public PortfolioRiskExactSigma(Matrix Sigma, MatrixRoot root) {
        this(Sigma, root.getRoot(Sigma));
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) {
        return true;
    }

    public PortfolioRiskExactSigma(Matrix Sigma, Matrix sigmaRoot) {
        this.enum = Sigma;
        this.goto = sigmaRoot;
        int a2 = Sigma.nCols();
        SOCPGeneralConstraints a3 = this.newSOCPGeneralConstraints(new SOCPPortfolioConstraint.Variable("y", a2), new SOCPPortfolioConstraint.Variable("t1", 1));
        ArrayList<SparseMatrix.Entry> a4 = new ArrayList<SparseMatrix.Entry>();
        for (int a5 = 1; a5 <= a2; ++a5) {
            for (int a6 = 1; a6 <= a2; ++a6) {
                a4.add(new SparseMatrix.Entry(new MatrixCoordinate(a5, a6), sigmaRoot.get(a5, a6)));
            }
        }
        a4.add(new SparseMatrix.Entry(new MatrixCoordinate(a2 + 1, a2 + 1), 0.5));
        CSRSparseMatrix a7 = new CSRSparseMatrix(a2 + 1, a2 + 1, a4);
        SparseVector a8 = new SparseVector(a2 + 1, new int[]{a2 + 1}, new double[]{-0.5});
        a8.set(a2 + 1, -0.5);
        SparseVector a9 = new SparseVector(a2 + 1, new int[]{a2 + 1}, new double[]{0.5});
        double a10 = 0.5;
        a3.add(new SOCPGeneralConstraint(a7, a8, a9, a10));
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }

    @Override
    public Double evaluate(Vector y) {
        return new VariancebtX(y, this.enum).doubleValue();
    }

    @Override
    public Matrix Sigma() {
        return new ImmutableMatrix(this.enum);
    }

    public Matrix root() {
        return new ImmutableMatrix(this.goto);
    }

    @Override
    public int dimensionOfDomain() {
        return this.enum.nCols();
    }

    public static class Diagonalization
    implements MatrixRoot {
        @Override
        public Matrix getRoot(Matrix A2) {
            return new MatrixRootByDiagonalization(A2);
        }
    }

    public static class DefaultRoot
    implements MatrixRoot {
        @Override
        public Matrix getRoot(Matrix A2) {
            Densifiable a2;
            try {
                CholeskyBanachiewiczParallelized a3 = new CholeskyBanachiewiczParallelized(A2);
                a2 = a3.L();
            }
            catch (Exception a4) {
                a2 = new MatrixRootByDiagonalization(A2);
            }
            return a2;
        }
    }

    public static interface MatrixRoot {
        public Matrix getRoot(Matrix var1);
    }
}

