/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.convex.sdp.pathfollowing;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.Chol;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.CongruentMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.MAT;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import dev.nm.algebra.linear.matrix.doubles.operation.SVEC;
import dev.nm.algebra.linear.matrix.doubles.operation.SymmetricKronecker;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.solver.IterativeSolution;
import dev.nm.solver.multivariate.constrained.ConstrainedMinimizer;
import dev.nm.solver.multivariate.constrained.convex.sdp.pathfollowing.CentralPath;
import dev.nm.solver.multivariate.constrained.convex.sdp.problem.SDPDualProblem;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PrimalDualPathFollowingMinimizer
implements ConstrainedMinimizer<SDPDualProblem, IterativeSolution<CentralPath>> {
    private final double class;
    private final double goto;
    private final double enum;

    protected static double getMinEigenValue(Matrix A2, double epsilon) {
        Eigen a2 = new Eigen(A2, Eigen.Method.SYMMETRY, epsilon);
        double[] a3 = a2.getRealEigenvalues();
        return a3[a3.length - 1];
    }

    @Override
    public Solution solve(SDPDualProblem problem) throws Exception {
        return new Solution(problem, this.class, this.goto);
    }

    public PrimalDualPathFollowingMinimizer(double gamma0, double sigma0, double epsilon) {
        this.class = gamma0;
        this.goto = sigma0;
        this.enum = epsilon;
    }

    public PrimalDualPathFollowingMinimizer(double epsilon) {
        this(0.9, epsilon);
    }

    static {
        Package.validate("NMDEV_SOLVER");
    }

    public PrimalDualPathFollowingMinimizer(double gamma0, double epsilon) {
        this(gamma0, Double.NaN, epsilon);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Solution
    implements IterativeSolution<CentralPath> {
        protected final Matrix A;
        protected double phi;
        protected double delta = Double.POSITIVE_INFINITY;
        protected double gamma;
        protected int iter = 0;
        protected final int n;
        protected final Matrix I;
        protected CentralPath path;
        protected final SDPDualProblem problem;
        protected double sigma;

        public CentralPath search(CentralPath initial) throws Exception {
            this.setInitials(initial);
            while (this.step().booleanValue()) {
                ++this.iter;
            }
            return this.path;
        }

        @Override
        public Boolean step() {
            this.delta = MatrixMeasure.tr(this.path.X.multiply(this.path.S)) / (double)this.n;
            if (this.delta < PrimalDualPathFollowingMinimizer.this.enum) {
                return false;
            }
            double a2 = this.sigma * this.delta;
            SymmetricKronecker a3 = new SymmetricKronecker(this.path.S, this.I);
            SymmetricKronecker a4 = new SymmetricKronecker(this.path.X, this.I);
            SVEC a5 = new SVEC(this.I.scaled(a2).minus(this.path.X.multiply(this.path.S).add(this.path.S.multiply(this.path.X)).scaled(0.5)));
            SVEC a6 = new SVEC(this.path.X);
            Vector a7 = this.problem.b().minus(this.A.multiply(a6));
            SVEC a8 = new SVEC(this.problem.C().minus(this.path.S).minus(new MAT(this.A.t().multiply(this.path.y))));
            Vector a9 = a4.multiply(a8).minus(a5);
            Inverse a10 = new Inverse((Matrix)a3);
            Matrix a11 = this.A.multiply(a10);
            Matrix a12 = a11.multiply(a4).multiply(this.A.t());
            Inverse a13 = new Inverse(a12);
            Vector a14 = a7.add(this.A.multiply(a10).multiply(a9));
            Vector a15 = a13.multiply(a14);
            Vector a16 = this.A.t().multiply(a15);
            Vector a17 = ((DenseMatrix)a10.scaled(-1.0)).multiply(a9.minus(a4.multiply(a16)));
            Vector a18 = a8.minus(a16);
            MAT a19 = new MAT(a17);
            MAT a20 = new MAT(a18);
            double a21 = this.do(this.path.X, a19);
            double a22 = this.do(this.path.S, a20);
            this.path = new CentralPath(this.path.X.add(a19.scaled(a21)), this.path.y.add(a15.scaled(a22)), this.path.S.add(a20.scaled(a22)));
            double a23 = a7.norm();
            double a24 = a8.norm();
            this.phi = this.delta + a23 + a24;
            return this.phi > PrimalDualPathFollowingMinimizer.this.enum;
        }

        public CentralPath search(CentralPath ... initials) throws Exception {
            switch (initials.length) {
                case 0: {
                    return this.search();
                }
                case 1: {
                    return this.search(initials[0]);
                }
            }
            throw new IllegalArgumentException("wrong number of parameters");
        }

        public CentralPath search() throws Exception {
            return this.search(new CentralPath(this.problem.C().ONE(), this.problem.b().ZERO(), this.problem.C().ONE()));
        }

        public void setInitials(CentralPath ... initials) {
            this.path = initials[0];
        }

        private double do(Matrix a2, Matrix a3) {
            Solution a4;
            Chol a5 = new Chol(a2);
            UpperTriangularMatrix a6 = a5.Lt();
            Inverse a7 = new Inverse(a6);
            SymmetricMatrix a8 = new SymmetricMatrix(new CongruentMatrix((Matrix)a7, a3));
            double a9 = PrimalDualPathFollowingMinimizer.getMinEigenValue(a8, a4.PrimalDualPathFollowingMinimizer.this.enum);
            double a10 = 1.0;
            if (a9 < 0.0) {
                a10 = Math.min(1.0, -a4.gamma / a9);
            }
            return a10;
        }

        protected Matrix svecA() {
            ArrayList<Vector> a2 = new ArrayList<Vector>();
            for (int a3 = 1; a3 <= this.problem.p(); ++a3) {
                a2.add(new SVEC(this.problem.A(a3)));
            }
            Matrix a4 = MatrixFactory.rbind(a2);
            return a4;
        }

        @Override
        public double minimum() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected Solution(SDPDualProblem problem, double gamma0, double sigma0) {
            this.phi = Double.POSITIVE_INFINITY;
            this.problem = problem;
            this.gamma = gamma0;
            this.n = problem.n();
            this.sigma = !Double.isNaN(sigma0) ? sigma0 : (double)this.n / (15.0 * Math.sqrt(this.n) + (double)this.n);
            this.I = problem.C().ONE();
            this.A = this.svecA();
        }

        @Override
        public CentralPath minimizer() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

