/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.number;

import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.complex.Complex;

public final class NumberUtils {
    public static boolean isReal(Number number) {
        boolean a2 = true;
        if (number instanceof Complex) {
            a2 = Complex.isReal((Complex)number);
        }
        return a2;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public static Number parse(String str) {
        String a2 = str.trim();
        Number a3 = null;
        if (a2.endsWith("i")) {
            String a4 = "";
            String a5 = "";
            int a6 = Math.max(a2.lastIndexOf("+"), a2.lastIndexOf("-"));
            if (a6 > 1 && (a2.charAt(a6 - 1) == 'e' || a2.charAt(a6 - 1) == 'E')) {
                a6 = Math.max(a2.lastIndexOf("+", a6 - 1), a2.lastIndexOf("-", a6 - 1));
            }
            if (a6 == -1) {
                a5 = a2.length() < 2 ? "" : a2.substring(0, a2.length() - 2);
            } else {
                a5 = a2.length() - 1 < a6 + 1 ? "" : a2.substring(a6 + 1, a2.length() - 1);
                a4 = a6 < 0 ? "" : a2.substring(0, a6);
            }
            double a7 = 0.0;
            if (a4.trim().length() > 0) {
                a7 = Double.parseDouble(a4);
            }
            double a8 = 1.0;
            if (a5.trim().length() > 0) {
                a8 = Double.parseDouble(a5);
            }
            double a9 = a6 > -1 && a2.substring(a6, a6 + 1).equals("-") ? -1.0 : 1.0;
            a3 = new Complex(a7, a9 * a8);
        } else {
            double a10 = Double.parseDouble(a2);
            a3 = new Double(a10);
        }
        return a3;
    }

    private NumberUtils() {
        NumberUtils a2;
    }

    public static Number[] parseArray(String ... strs) {
        Number[] a2 = new Number[strs.length];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = NumberUtils.parse(strs[a3]);
        }
        return a2;
    }

    public static int compare(Number num1, Number num2, double epsilon) {
        double a2 = Double.NaN;
        double a3 = Double.NaN;
        try {
            a2 = num1.doubleValue();
        }
        catch (Throwable a4) {
            a2 = Double.NaN;
        }
        try {
            a3 = num2.doubleValue();
        }
        catch (Throwable a5) {
            a3 = Double.NaN;
        }
        try {
            Comparable a6;
            if (!Double.isNaN(a2) && !Double.isNaN(a3)) {
                return DoubleUtils.compare(a2, a3, epsilon);
            }
            if (Double.isNaN(a2) && Double.isNaN(a3)) {
                a6 = (Comparable)((Object)num1);
                return a6.compare(num2, epsilon);
            }
            if (Double.isNaN(a2)) {
                a6 = (Comparable)((Object)num1);
                return a6.compare(num2, epsilon);
            }
            if (Double.isNaN(a3)) {
                a6 = (Comparable)((Object)num2);
                return -a6.compare(num1, epsilon);
            }
            throw new RuntimeException("unreachable");
        }
        catch (Throwable a7) {
            throw new RuntimeException(String.format("unable to compare these two numbers: %s vs. %s", num1.toString(), num2.toString()));
        }
    }

    public static boolean equal(Number num1, Number num2, double epsilon) {
        return NumberUtils.compare(num1, num2, epsilon) == 0;
    }

    public static interface Comparable<T extends Number> {
        public int compare(Number var1, double var2);
    }
}

