/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.misc.license;

import dev.nm.misc.StringUtils;
import dev.nm.misc.license.InvalidLicense;
import dev.nm.misc.license.LicenseError;
import dev.nm.misc.license.LicenseSource;
import dev.nm.misc.license.Package;
import dev.nm.zzz.con.prn.aux.nul.C;
import dev.nm.zzz.con.prn.aux.nul.D;
import dev.nm.zzz.con.prn.aux.nul.E;
import dev.nm.zzz.con.prn.aux.nul.G;
import dev.nm.zzz.con.prn.aux.nul.g;
import dev.nm.zzz.con.prn.aux.nul.j;
import dev.nm.zzz.con.prn.aux.nul.k;
import dev.nm.zzz.con.prn.aux.nul.l;
import dev.nm.zzz.con.prn.aux.nul.m;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class License {
    private static final G class;
    private static LicenseSource goto;
    public static final String DATE_FORMAT_STRING = "yyyy-MM-dd";
    private static g enum;
    public static final String LICENSE_FILE_PROPERTY = "nm.license";
    public static final String[] DEFAULT_LICENSE_FILES;

    private static void do(URL a2) {
        License.short();
        goto = LicenseSource.fromUrl(a2);
        try {
            enum = E.do(a2);
        }
        catch (IOException a3) {
            throw new LicenseError("error loading license file");
        }
        License.goto();
    }

    public static void setLicenseKey(String key) {
        License.short();
        goto = LicenseSource.fromKey(key, License.do());
        try {
            enum = g.short(key);
        }
        catch (Exception a2) {
            throw new InvalidLicense("invalid license key");
        }
        License.goto();
    }

    static {
        DEFAULT_LICENSE_FILES = new String[]{"nm.lic"};
        License.class = new G(1, 2, 4);
        goto = LicenseSource.notLoaded();
    }

    static boolean isValidated(Package a2) {
        License.checkDotNetValidity();
        if (!License.do(a2.name)) {
            return false;
        }
        return Boolean.parseBoolean(License.do().short(a2.name));
    }

    private static void break() {
        k a2 = new k();
        a2.do(enum);
    }

    private static boolean do(String a2) {
        return License.do().do(a2);
    }

    static boolean isValidated(Date a2) {
        String a3 = License.do().short(j.final.do());
        String a4 = License.do().short(j.class.do());
        D a5 = new D(a2);
        return a5.do(a3, a4);
    }

    static boolean isDotNetLicensed() {
        return License.do("DOTNET") && Boolean.parseBoolean(License.do().short("DOTNET"));
    }

    private static void goto() {
        License.break();
        License.case();
        License.do();
    }

    private static String do() {
        StackTraceElement a2 = Thread.currentThread().getStackTrace()[3];
        return String.format("%s::%s(%s:%s)", a2.getClassName(), a2.getMethodName(), a2.getFileName(), a2.getLineNumber());
    }

    private static void case() {
        String a2 = License.do().short(j.goto.do()).trim();
        if (StringUtils.isNullOrEmpty(a2)) {
            a2 = License.do().short(j.else.do()).trim();
        }
        C a3 = new C(License.class);
        a3.do(a2);
    }

    private License() {
        License a2;
    }

    private static g do() {
        if (enum == null) {
            URL a2 = null;
            for (String a3 : DEFAULT_LICENSE_FILES) {
                String a4 = System.getProperty(LICENSE_FILE_PROPERTY, a3);
                try {
                    a2 = E.do(a4);
                }
                catch (FileNotFoundException a5) {
                    // empty catch block
                }
            }
            if (a2 == null) {
                throw new LicenseError("license file not found - put the license file in the classpath, working directory, or next to nmdev.jar");
            }
            License.do(a2);
        }
        return enum;
    }

    private static void short() {
        if (enum != null) {
            throw new LicenseError("license has been loaded already");
        }
    }

    static void checkDotNetValidity() {
        if (License.isDotNetLicensed()) {
            m a2 = new m();
            a2.short();
        }
    }

    public static void setLicenseFile(File licenseFile) {
        License.short();
        goto = LicenseSource.fromFile(licenseFile);
        try {
            enum = E.do(licenseFile);
        }
        catch (IOException a2) {
            throw new LicenseError("error loading license file");
        }
        License.goto();
    }

    public static String getLicenseKey() {
        return License.do().goto();
    }

    public static String getVersion() {
        return License.class.toString();
    }

    static boolean isValidated(Package a2, G a3) {
        if (!License.do(a2.name)) {
            return false;
        }
        String a4 = License.do().short(a2.name);
        C a5 = new C(a3);
        return a5.do(a4);
    }

    public static String getValue(String name) {
        return License.do().short(name);
    }

    private static void do() {
        List<String> a2 = Arrays.asList(License.do().short(j.super.do()).split(","));
        l a3 = new l();
        a3.do(a2);
    }

    public static String getLicenseLocation() {
        return License.getLicenseSource().toString();
    }

    static LicenseSource getLicenseSource() {
        return goto;
    }
}

